package org.tkit.rhpam.quarkus.tracing;

import javax.interceptor.InterceptorBinding;
import java.lang.annotation.*;

/**
 * Interceptor binding for tracing of AMQP consumer methods. The annotated method **MUST** have an AMQP message as its first attribute.
 * The trace will be constructed using the opentracing attributes stored in the message metadata/application properties.
 */
@Documented
@InterceptorBinding
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
public @interface TraceFromMessage {
}
