package org.tkit.rhpam.quarkus.messaging.common;

import lombok.Getter;
import lombok.Setter;

/**
 * The type Rhpam exception.
 */
@Getter
@Setter
public class RhpamException extends Exception {

    private String errorCode;

    private String errorMessage;
    /**
     * Instantiates a new Rhpam exception.
     *
     * @param message the message
     */
    public RhpamException(String message) {
        super(message);
    }

    /**
     * New RHPAM exception with error code and error message.
     * @param errorCode the error code
     * @param errorMessage the error message
     * @param cause the causing exception
     */
    public RhpamException(String errorCode, String errorMessage, Exception cause) {
        super(errorCode, cause);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    /**
     * Instantiates a new Rhpam exception.
     *
     * @param message the message
     * @param cause   the cause
     */
    public RhpamException(String message, Throwable cause) {
        super(message, cause);
    }
}
