/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.domain.daos;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.transaction.Transactional;
import org.eclipse.microprofile.opentracing.Traced;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.quarkus.jpa.daos.AbstractDAO;
import org.tkit.rhpam.quarkus.domain.models.FailedStep;
import org.tkit.rhpam.quarkus.domain.models.FailedStepSearchCriteria;

@ApplicationScoped
@Transactional
@Traced
public class FailedStepDAO
extends AbstractDAO<FailedStep> {
    private static final Logger log = LoggerFactory.getLogger(FailedStepDAO.class);

    public List<FailedStep> findBySearchCriteria(FailedStepSearchCriteria searchCriteria) {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(FailedStep.class).distinct(true);
        Root root = cq.from(FailedStep.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (searchCriteria != null) {
            if (searchCriteria.getProcessInstanceId() != null) {
                predicates.add(cb.equal((Expression)root.get("processInstanceId"), (Object)searchCriteria.getProcessInstanceId()));
            }
            if (searchCriteria.getParentProcessInstanceId() != null) {
                predicates.add(cb.equal((Expression)root.get("parentProcessInstanceId"), (Object)searchCriteria.getParentProcessInstanceId()));
            }
            if (searchCriteria.getProcessName() != null) {
                predicates.add(cb.equal((Expression)root.get("processName"), (Object)searchCriteria.getProcessName()));
            }
            if (searchCriteria.getProcessStepLogGuid() != null) {
                predicates.add(cb.equal((Expression)root.get("processStepLogGuid"), (Object)searchCriteria.getProcessStepLogGuid()));
            }
            if (searchCriteria.getProcessStepName() != null) {
                predicates.add(cb.equal((Expression)root.get("processStepName"), (Object)searchCriteria.getProcessStepName()));
            }
            if (searchCriteria.getReferenceBid() != null) {
                predicates.add(cb.equal((Expression)root.get("referenceBid"), (Object)String.valueOf(searchCriteria.getReferenceBid())));
            }
            if (searchCriteria.getReferenceKey() != null) {
                predicates.add(cb.equal((Expression)root.get("referenceKey"), (Object)searchCriteria.getReferenceKey()));
            }
            if (searchCriteria.getWorkItemId() != null) {
                predicates.add(cb.equal((Expression)root.get("workItemId"), (Object)searchCriteria.getWorkItemId()));
            }
            if (searchCriteria.getFailureType() != null) {
                predicates.add(cb.equal((Expression)root.get("failureType"), (Object)searchCriteria.getFailureType()));
            }
            if (searchCriteria.getStatus() != null) {
                predicates.add(cb.equal((Expression)root.get("status"), (Object)searchCriteria.getStatus()));
            }
        }
        if (!predicates.isEmpty()) {
            cq.where((Expression)cb.and(predicates.toArray(new Predicate[0])));
        }
        cq.orderBy(new Order[]{cb.desc((Expression)root.get("creationDate"))});
        List results = this.getEntityManager().createQuery(cq).getResultList();
        return results;
    }

    public Map<Long, Boolean> getProcessInstanceIdToHasFailedStepMapByInstanceIdList(List<Long> processInstanceIds) {
        if (processInstanceIds == null || processInstanceIds.isEmpty()) {
            return new HashMap<Long, Boolean>();
        }
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Object[].class);
        Root failedStepRoot = cq.from(FailedStep.class);
        cq.multiselect(new Selection[]{failedStepRoot.get("processInstanceId"), cb.count((Expression)failedStepRoot)});
        cq.where(new Predicate[]{failedStepRoot.get("processInstanceId").in(processInstanceIds), cb.equal((Expression)failedStepRoot.get("status"), (Object)FailedStep.FailedStepStatus.OPEN)});
        cq.groupBy(new Expression[]{failedStepRoot.get("processInstanceId")});
        List results = this.getEntityManager().createQuery(cq).getResultList();
        HashMap<Long, Boolean> ret = new HashMap<Long, Boolean>();
        for (Object[] result : results) {
            Long processInstanceId = (Long)result[0];
            int count = ((Number)result[1]).intValue();
            ret.put(processInstanceId, count > 0);
        }
        return ret;
    }
}

