package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;


/**
 * The type Message event.
 */
public class MessageEvent extends ProcessLogEvent {
    private @Valid
    String content = null;
    private @Valid
    String description = null;
    private @Valid
    String messageKey = null;
    private @Valid
    Map<String, String> messageParams = new HashMap<String, String>();
    private @Valid @NotNull
    String nodeId = null;
    private @Valid
    Severity severity = null;

    /**
     * Content message event.
     *
     * @param content the content
     * @return the message event
     */
    public MessageEvent content(String content) {
        this.content = content;
        return this;
    }

    /**
     * Put metadata item.
     *
     * @param key   the key
     * @param value the value
     */
    public void putMetadataItem(String key, Object value) {
       getMetadata().put(key, value);
    }

    /**
     * Gets content.
     *
     * @return the content
     */
    @JsonProperty("content")

    public String getContent() {
        return content;
    }

    /**
     * Sets content.
     *
     * @param content the content
     */
    public void setContent(String content) {
        this.content = content;
    }

    /**
     * Description message event.
     *
     * @param description the description
     * @return the message event
     */
    public MessageEvent description(String description) {
        this.description = description;
        return this;
    }


    /**
     * Gets description.
     *
     * @return the description
     */
    @JsonProperty("description")

    public String getDescription() {
        return description;
    }

    /**
     * Sets description.
     *
     * @param description the description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Message key message event.
     *
     * @param messageKey the message key
     * @return the message event
     */
    public MessageEvent messageKey(String messageKey) {
        this.messageKey = messageKey;
        return this;
    }


    /**
     * Gets message key.
     *
     * @return the message key
     */
    @JsonProperty("messageKey")

    public String getMessageKey() {
        return messageKey;
    }

    /**
     * Sets message key.
     *
     * @param messageKey the message key
     */
    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    /**
     * Message params message event.
     *
     * @param messageParams the message params
     * @return the message event
     */
    public MessageEvent messageParams(Map<String, String> messageParams) {
        this.messageParams = messageParams;
        return this;
    }


    /**
     * Gets message params.
     *
     * @return the message params
     */
    @JsonProperty("messageParams")

    public Map<String, String> getMessageParams() {
        return messageParams;
    }

    /**
     * Sets message params.
     *
     * @param messageParams the message params
     */
    public void setMessageParams(Map<String, String> messageParams) {
        this.messageParams = messageParams;
    }

    /**
     * Node id message event.
     *
     * @param nodeId the node id
     * @return the message event
     */
    public MessageEvent nodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }


    /**
     * Gets node id.
     *
     * @return the node id
     */
    @JsonProperty("nodeId")

    public String getNodeId() {
        return nodeId;
    }

    /**
     * Sets node id.
     *
     * @param nodeId the node id
     */
    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    /**
     * Severity message event.
     *
     * @param severity the severity
     * @return the message event
     */
    public MessageEvent severity(Severity severity) {
        this.severity = severity;
        return this;
    }


    /**
     * Gets severity.
     *
     * @return the severity
     */
    @JsonProperty("severity")

    public Severity getSeverity() {
        return severity;
    }

    /**
     * Sets severity.
     *
     * @param severity the severity
     */
    public void setSeverity(Severity severity) {
        this.severity = severity;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessageEvent messageEvent = (MessageEvent) o;
        return Objects.equals(content, messageEvent.content) &&
                Objects.equals(description, messageEvent.description) &&
                Objects.equals(messageKey, messageEvent.messageKey) &&
                Objects.equals(messageParams, messageEvent.messageParams) &&
                Objects.equals(nodeId, messageEvent.nodeId) &&
                Objects.equals(severity, messageEvent.severity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(content, description, messageKey, messageParams, nodeId, severity);
    }

    @Override
    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageEvent {\n");
        sb.append("    ").append(toIndentedString(super.toPrettyString())).append("\n");
        sb.append("    content: ").append(toIndentedString(content, true)).append("\n");
        sb.append("    description: ").append(toIndentedString(description, true)).append("\n");
        sb.append("    messageKey: ").append(toIndentedString(messageKey)).append("\n");
        sb.append("    messageParams: ").append(toIndentedString(messageParams)).append("\n");
        sb.append("    nodeId: ").append(toIndentedString(nodeId)).append("\n");
        sb.append("    severity: ").append(toIndentedString(severity)).append("\n");
        sb.append("}");
        return sb.toString();
    }


}
