package org.tkit.rhpam.quarkus.common;

import lombok.Getter;


/**
 * Message Keys used in RHPAM lib
 */
@Getter
public enum MessageKeys {
    /**
     * Process step reports business error, but did not specify error code.
     */
    FAILED_STEP_WITHOUT_ERROR_CODE("TKIT_RHPAM_001", "Process step result FAILED without FAILED_STEP_ERROR_CODE out param"),
    /**
     * Process step threw exception other then {@link org.tkit.rhpam.quarkus.messaging.common.RhpamException} and no error info provided
     */
    EXCEPTION_IN_STEP_WITHOUT_ERROR_CODE("TKIT_RHPAM_002", "Process step result in unexpected exception without additional error info"),
    /**
     * Business process error handler was invoked, but the Failed Step info (from actual business step) is not available.
     */
    BUSINESS_ERR_HANDLER_MISSING_FAILED_STEP("TKIT_RHPAM_003", "Business error handler invoked but no matching failed step found: %s"),

    TECHNICAL_ERROR_IN_STEP_EXEC("TKIT_RHPAM_004", "Technical error in step: %s"),
    ;

    private String errorCode;
    private String message;

    MessageKeys(String errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    @Override
    public String toString() {
        return  this.errorCode + " : " + this.message;
    }

    public String formatMessage(String... args) {
        return String.format(this.message, args);
    }
}
