package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets Resolution
 */
public enum Resolution {
    /**
     * Aborted resolution.
     */
    ABORTED("ABORTED"),
    /**
     * Failed resolution.
     */
    FAILED("FAILED"),
    /**
     * Successful resolution.
     */
    SUCCESSFUL("SUCCESSFUL"),
    /**
     * Successful with warnings resolution.
     */
    SUCCESSFUL_WITH_WARNINGS("SUCCESSFUL_WITH_WARNINGS");

    private String value;

    Resolution(String value) {
        this.value = value;
    }

    /**
     * From value resolution.
     *
     * @param text the text
     * @return the resolution
     */
    @JsonCreator
    public static Resolution fromValue(String text) {
        for (Resolution b : Resolution.values()) {
            if (String.valueOf(b.value).equals(text)) {
                return b;
            }
        }
        return null;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }
}
