package org.tkit.rhpam.quarkus.messaging.model;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * The type Process step execution result.
 */
@Getter
@Setter
@ToString(onlyExplicitlyIncluded = true)
public class ProcessStepExecutionResult {

    /**
     * The result data.
     */
    private Map<String, Object> parameters = new HashMap<>();

    /**
     * The resolution status.
     */
    @ToString.Include
    private ResolutionStatus status = ResolutionStatus.SUCCESSFUL;

    /**
     * Instantiates a new Process step execution result.
     *
     * @param status     the status
     * @param parameters the parameters
     */
    public ProcessStepExecutionResult( ResolutionStatus status, Map<String, Object> parameters) {
        this.status = status;
        this.parameters = parameters;
    }

    /**
     * Builder builder.
     *
     * @return the builder
     */
    public static Builder builder() {
        return new Builder();
    }

    /**
     * The type Builder.
     */
    public static class Builder {
        private Map<String, Object> parameters = new HashMap<>();

        private ResolutionStatus status = ResolutionStatus.SUCCESSFUL;

        /**
         * Instantiates a new Builder.
         */
        public Builder() {}

        /**
         * Add parameter builder.
         *
         * @param key   the key
         * @param value the value
         * @return the builder
         */
        public Builder addParameter(String key, Object value) {
            this.parameters.put(key, value);
            return this;
        }

        /**
         * With parameters builder.
         *
         * @param parameters the parameters
         * @return the builder
         */
        public Builder withParameters(Map<String, Object> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Status builder.
         *
         * @param resolutionStatus the resolution status
         * @return the builder
         */
        public Builder status(ResolutionStatus resolutionStatus) {
            this.status = resolutionStatus;
            return this;
        }

        /**
         * Build process step execution result.
         *
         * @return the process step execution result
         */
        public ProcessStepExecutionResult build() {
            return new ProcessStepExecutionResult(this.status, this.parameters);
        }
    }
}
