/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.messaging.model;

import java.util.Date;
import java.util.Map;
import org.tkit.rhpam.quarkus.messaging.model.AbstractProcessItem;
import org.tkit.rhpam.quarkus.messaging.model.NodeType;
import org.tkit.rhpam.quarkus.messaging.model.ProcessEventType;
import org.tkit.rhpam.quarkus.messaging.model.ProcessState;

public class ProcessEventItem
extends AbstractProcessItem {
    private ProcessEventType processEventType;
    private String outcome;
    private boolean error;
    private String nodeResolutionStatus;
    private String correlationId;
    private Long subProcessId;
    private String listenerType;

    public ProcessEventItem(Long timerId, Long workItemId, Long executionId, NodeType nodeType, Long referenceBid, String referenceKey, ProcessEventType processEventType, String listenerType, String body, String processLogGuid, String processId, String processName, String processVersion, Long processInstanceId, Date executionDate, String deploymentId, String name, Long nodeId, Long parentProcessInstanceId, String boundaryEventId, Map<String, Object> parameters, String outcome, boolean error, String nodeResolutionStatus, String parentProcessId, String correlationId, Long subProcessId, ProcessState processState) {
        super(processLogGuid, executionId, timerId, workItemId, body, nodeType, referenceBid, referenceKey, processId, processName, processVersion, processInstanceId, executionDate, deploymentId, name, nodeId, parentProcessInstanceId, boundaryEventId, parameters, parentProcessId, processState);
        this.listenerType = listenerType;
        this.processEventType = processEventType;
        this.error = error;
        this.outcome = outcome;
        this.nodeResolutionStatus = nodeResolutionStatus;
        this.correlationId = correlationId;
        this.subProcessId = subProcessId;
    }

    public static ProcessEventItemBuilder builder() {
        return new ProcessEventItemBuilder();
    }

    public ProcessEventType getProcessEventType() {
        return this.processEventType;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public boolean isError() {
        return this.error;
    }

    public String getNodeResolutionStatus() {
        return this.nodeResolutionStatus;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public Long getSubProcessId() {
        return this.subProcessId;
    }

    public String getListenerType() {
        return this.listenerType;
    }

    @Override
    public String toString() {
        return "ProcessEventItem(super=" + super.toString() + ", processEventType=" + this.getProcessEventType() + ", outcome=" + this.getOutcome() + ", error=" + this.isError() + ", nodeResolutionStatus=" + this.getNodeResolutionStatus() + ", correlationId=" + this.getCorrelationId() + ", subProcessId=" + this.getSubProcessId() + ")";
    }

    public static class ProcessEventItemBuilder {
        private Long timerId;
        private Long workItemId;
        private Long executionId;
        private NodeType nodeType;
        private Long referenceBid;
        private String referenceKey;
        private ProcessEventType processEventType;
        private String listenerType;
        private String body;
        private String processLogGuid;
        private String processId;
        private String processName;
        private String processVersion;
        private Long processInstanceId;
        private Date executionDate;
        private String deploymentId;
        private String name;
        private Long nodeId;
        private Long parentProcessInstanceId;
        private String boundaryEventId;
        private Map<String, Object> parameters;
        private String outcome;
        private boolean error;
        private String nodeResolutionStatus;
        private String parentProcessId;
        private String correlationId;
        private Long subProcessId;
        private ProcessState processState;

        ProcessEventItemBuilder() {
        }

        public ProcessEventItemBuilder timerId(Long timerId) {
            this.timerId = timerId;
            return this;
        }

        public ProcessEventItemBuilder workItemId(Long workItemId) {
            this.workItemId = workItemId;
            return this;
        }

        public ProcessEventItemBuilder executionId(Long executionId) {
            this.executionId = executionId;
            return this;
        }

        public ProcessEventItemBuilder nodeType(NodeType nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public ProcessEventItemBuilder referenceBid(Long referenceBid) {
            this.referenceBid = referenceBid;
            return this;
        }

        public ProcessEventItemBuilder referenceKey(String referenceKey) {
            this.referenceKey = referenceKey;
            return this;
        }

        public ProcessEventItemBuilder processEventType(ProcessEventType processEventType) {
            this.processEventType = processEventType;
            return this;
        }

        public ProcessEventItemBuilder listenerType(String listenerType) {
            this.listenerType = listenerType;
            return this;
        }

        public ProcessEventItemBuilder body(String body) {
            this.body = body;
            return this;
        }

        public ProcessEventItemBuilder processLogGuid(String processLogGuid) {
            this.processLogGuid = processLogGuid;
            return this;
        }

        public ProcessEventItemBuilder processId(String processId) {
            this.processId = processId;
            return this;
        }

        public ProcessEventItemBuilder processName(String processName) {
            this.processName = processName;
            return this;
        }

        public ProcessEventItemBuilder processVersion(String processVersion) {
            this.processVersion = processVersion;
            return this;
        }

        public ProcessEventItemBuilder processInstanceId(Long processInstanceId) {
            this.processInstanceId = processInstanceId;
            return this;
        }

        public ProcessEventItemBuilder executionDate(Date executionDate) {
            this.executionDate = executionDate;
            return this;
        }

        public ProcessEventItemBuilder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public ProcessEventItemBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ProcessEventItemBuilder nodeId(Long nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public ProcessEventItemBuilder parentProcessInstanceId(Long parentProcessInstanceId) {
            this.parentProcessInstanceId = parentProcessInstanceId;
            return this;
        }

        public ProcessEventItemBuilder boundaryEventId(String boundaryEventId) {
            this.boundaryEventId = boundaryEventId;
            return this;
        }

        public ProcessEventItemBuilder parameters(Map<String, Object> parameters) {
            this.parameters = parameters;
            return this;
        }

        public ProcessEventItemBuilder outcome(String outcome) {
            this.outcome = outcome;
            return this;
        }

        public ProcessEventItemBuilder error(boolean error) {
            this.error = error;
            return this;
        }

        public ProcessEventItemBuilder nodeResolutionStatus(String nodeResolutionStatus) {
            this.nodeResolutionStatus = nodeResolutionStatus;
            return this;
        }

        public ProcessEventItemBuilder parentProcessId(String parentProcessId) {
            this.parentProcessId = parentProcessId;
            return this;
        }

        public ProcessEventItemBuilder correlationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public ProcessEventItemBuilder subProcessId(Long subProcessId) {
            this.subProcessId = subProcessId;
            return this;
        }

        public ProcessEventItemBuilder processState(ProcessState processState) {
            this.processState = processState;
            return this;
        }

        public ProcessEventItem build() {
            return new ProcessEventItem(this.timerId, this.workItemId, this.executionId, this.nodeType, this.referenceBid, this.referenceKey, this.processEventType, this.listenerType, this.body, this.processLogGuid, this.processId, this.processName, this.processVersion, this.processInstanceId, this.executionDate, this.deploymentId, this.name, this.nodeId, this.parentProcessInstanceId, this.boundaryEventId, this.parameters, this.outcome, this.error, this.nodeResolutionStatus, this.parentProcessId, this.correlationId, this.subProcessId, this.processState);
        }

        public String toString() {
            return "ProcessEventItem.ProcessEventItemBuilder(timerId=" + this.timerId + ", workItemId=" + this.workItemId + ", executionId=" + this.executionId + ", nodeType=" + this.nodeType + ", referenceBid=" + this.referenceBid + ", referenceKey=" + this.referenceKey + ", processEventType=" + this.processEventType + ", listenerType=" + this.listenerType + ", body=" + this.body + ", processLogGuid=" + this.processLogGuid + ", processId=" + this.processId + ", processName=" + this.processName + ", processVersion=" + this.processVersion + ", processInstanceId=" + this.processInstanceId + ", executionDate=" + this.executionDate + ", deploymentId=" + this.deploymentId + ", name=" + this.name + ", nodeId=" + this.nodeId + ", parentProcessInstanceId=" + this.parentProcessInstanceId + ", boundaryEventId=" + this.boundaryEventId + ", parameters=" + this.parameters + ", outcome=" + this.outcome + ", error=" + this.error + ", nodeResolutionStatus=" + this.nodeResolutionStatus + ", parentProcessId=" + this.parentProcessId + ", correlationId=" + this.correlationId + ", subProcessId=" + this.subProcessId + ", processState=" + this.processState + ")";
        }
    }
}

