package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.Valid;
import java.util.Objects;


/**
 * The type Resolution option.
 */
public class ResolutionOption {
    private @Valid
    String label = null;
    private @Valid
    String key = null;
    private @Valid
    String callBackUrl = null;

    /**
     * Label resolution option.
     *
     * @param label the label
     * @return the resolution option
     */
    public ResolutionOption label(String label) {
        this.label = label;
        return this;
    }


    /**
     * Gets label.
     *
     * @return the label
     */
    @JsonProperty("label")

    public String getLabel() {
        return label;
    }

    /**
     * Sets label.
     *
     * @param label the label
     */
    public void setLabel(String label) {
        this.label = label;
    }

    /**
     * Key resolution option.
     *
     * @param key the key
     * @return the resolution option
     */
    public ResolutionOption key(String key) {
        this.key = key;
        return this;
    }


    /**
     * Gets key.
     *
     * @return the key
     */
    @JsonProperty("key")

    public String getKey() {
        return key;
    }

    /**
     * Sets key.
     *
     * @param key the key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * Call back url resolution option.
     *
     * @param callBackUrl the call back url
     * @return the resolution option
     */
    public ResolutionOption callBackUrl(String callBackUrl) {
        this.callBackUrl = callBackUrl;
        return this;
    }


    /**
     * Gets call back url.
     *
     * @return the call back url
     */
    @JsonProperty("callBackUrl")

    public String getCallBackUrl() {
        return callBackUrl;
    }

    /**
     * Sets call back url.
     *
     * @param callBackUrl the call back url
     */
    public void setCallBackUrl(String callBackUrl) {
        this.callBackUrl = callBackUrl;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResolutionOption resolutionOption = (ResolutionOption) o;
        return Objects.equals(label, resolutionOption.label) &&
                Objects.equals(key, resolutionOption.key) &&
                Objects.equals(callBackUrl, resolutionOption.callBackUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(label, key, callBackUrl);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResolutionOption {\n");

        sb.append("    label: ").append(toIndentedString(label)).append("\n");
        sb.append("    key: ").append(toIndentedString(key)).append("\n");
        sb.append("    callBackUrl: ").append(toIndentedString(callBackUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
