package org.tkit.rhpam.quarkus.logging;

import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import org.tkit.quarkus.log.cdi.LogParam;

public class AmqpMessageFormatter {

    public static final String N_A = "N/A";

    @LogParam(classes = {AmqpMessage.class})
    public static String logAmqpMessage(Object message) {
        AmqpMessage a = (AmqpMessage) message;
        StringBuilder sb = new StringBuilder(", Id: ");
        sb.append(a.getApplicationProperties().getValue("TKIT_PROCESS_NAME", N_A));
        sb.append(", instance: ");
        sb.append(a.getApplicationProperties().getValue("TKIT_PROCESS_INSTANCE_ID", N_A));
        sb.append(", event: ");
        sb.append(a.getApplicationProperties().getValue("TKIT_PROCESS_LOG_EVENT", N_A));
        return "AmqpMessage[" + a.getMessageId() + ", attempt: " + (a.getDeliveryCount() + 1) + sb.toString() + "]";
    }

}
