package org.tkit.rhpam.quarkus.rs.clients;

import io.quarkus.runtime.annotations.RegisterForReflection;
import org.eclipse.microprofile.rest.client.annotation.RegisterClientHeaders;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;

import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.*;
import javax.ws.rs.core.Response;
import java.util.List;

/**
 * @author Agnė Matusevičiūtė
 */
@Path("/server")
@ApplicationScoped
@RegisterForReflection
@RegisterRestClient(configKey = "rest-api-kie-server")
@RegisterClientHeaders
public interface KieServerRestClient {

    @GET
    @Path("/containers/{containerId}/processes/instances/{processInstanceId}")
    Response getProcessInstance(@HeaderParam("Authorization") String basicAuthToken, @PathParam("containerId") String containerId, @PathParam("processInstanceId") Long processInstanceId);

    @GET
    @Path("/containers/{containerId}/processes/instances/{processInstanceId}/processes")
    Response getProcessInstances(@HeaderParam("Authorization") String basicAuthToken, @PathParam("containerId") String containerId, @PathParam("processInstanceId") Long processInstanceId);

    @DELETE
    @Path("/containers/{containerId}/processes/instances/{processInstanceId}")
    Response abortProcessInstance(@HeaderParam("Authorization") String basicAuthToken, @PathParam("containerId") String containerId, @PathParam("processInstanceId") Long processInstanceId);

    @DELETE
    @Path("/containers/{containerId}/processes/instances")
    Response abortProcessInstances(@HeaderParam("Authorization") String basicAuthToken, @PathParam("containerId") String containerId, @QueryParam("instanceId") List<Long> processInstanceIds);
}

