/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.messaging.common;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.smallrye.reactive.messaging.amqp.IncomingAmqpMetadata;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageUtil {
    private static final Logger log = LoggerFactory.getLogger(MessageUtil.class);
    public static final String FAILED_STEP_ERROR_CODE = "TKIT_FS_ERROR_CODE";
    public static final String FAILED_STEP_ERROR_MSG = "TKIT_FS_ERROR_MSG";
    public static final String FAILED_STEP_DEEP_LINK = "TKIT_FS_DEEP_LINK";
    public static final String PROP_PARENT_PROCESS_ID = "TKIT_PARENT_PROCESS_ID";
    public static final String PROP_TKIT_SUB_PROCESS_ID = "TKIT_SUB_PROCESS_ID";
    public static final String PROP_PROCESS_STATE = "PROP_PROCESS_STATE";
    public static final String PROP_CMD = "TKIT_CMD";
    public static final String RESPONSE_QUEUE = "tkitRhpamJbpmCommands";
    public static final String PROP_PROCESS_INSTANCE_ID = "TKIT_PROCESS_INSTANCE_ID";
    public static final String PROP_DEPLOYMENT_ID = "TKIT_DEPLOYMENT_ID";
    public static final String PROP_PROCESS_ID = "TKIT_PROCESS_ID";
    public static final String PROP_PROCESS_NAME = "TKIT_PROCESS_NAME";
    public static final String PROP_WORK_ITEM_ID = "TKIT_WORK_ITEM_ID";
    public static final String PROP_SIGNAL_ID = "TKIT_SIGNAL";
    public static final String PROP_SIGNAL_DATA = "TKIT_SIGNAL_DATA";
    public static final String PROP_TKIT_RESOLUTION_STATUS = "TKIT_RESOLUTION_STATUS";
    public static final String PROP_TKIT_CORRELATION_ID = "TKIT_CORRELATION_ID";
    public static final String PROP_KIE_NODE_ID = "TKIT_NODE_ID";
    public static final String PROP_KIE_LISTENER_TYPE = "TKIT_LISTENER_TYPE";
    public static final String PROP_KIE_NODE_NAME = "TKIT_NODE_NAME";
    public static final String PROP_KIE_NODE_TYPE = "TKIT_NODE_TYPE";
    public static final String PROP_KIE_EXECUTION_DATE = "TKIT_EXECUTION_DATE";
    public static final String PROP_PARENT_PROCESS_INSTANCE_ID = "TKIT_PARENT_PROCESS_INSTANCE_ID";
    public static final String PROP_PROCESS_VERSION = "TKIT_PROCESS_VERSION";
    public static final String PROP_KIE_PROCESS_LOG_EVENT = "TKIT_PROCESS_LOG_EVENT";
    public static final String PROP_PROCESS_LOG_GUID = "TKIT_PROCESS_LOG_GUID";
    public static final String PROP_PROCESS_EXEC_LOG_GUID = "TKIT_PROCESS_EXEC_LOG_GUID";
    public static final String PROP_EXECUTION_ID = "TKIT_EXECUTION_ID";
    public static final String PROP_REFERENCE_BID = "TKIT_REFERENCE_BID";
    public static final String PROP_REFERENCE_KEY = "TKIT_REFERENCE_KEY";
    public static final String PROP_BOUNDARY_EVENT_ID = "TKIT_BOUNDARY_EVENT_ID";
    public static final String PROP_TIMER_ID = "TKIT_TIMER_ID";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectReader READER = MAPPER.readerFor(Map.class);
    private static final ObjectWriter WRITER = MAPPER.writerFor(Map.class);
    public static final String PROP_PROCESS_OUTCOME = "PROP_PROCESS_OUTCOME";
    public static final String PROP_PROCESS_ERROR = "PROP_PROCESS_ERROR";
    public static final String PROP_X_CORRELATION_ID = "X_CORRELATION_ID";
    public static final String PROP_BEH_REFERENCED_STEP_NAME = "referencedStepId";
    public static final String PROP_BEH_RESOLUTION_SIGNAL_NAME = "resolutionSignalId";
    public static final String PROP_BEH_RESOLUTION_ACTIONS = "resolutionActions";

    private MessageUtil() {
    }

    public static <T> T getProperty(Message msg, String name) {
        IncomingAmqpMetadata meta = (IncomingAmqpMetadata)msg.getMetadata(IncomingAmqpMetadata.class).get();
        JsonObject msgProps = meta.getProperties();
        if (msgProps.containsKey(name)) {
            return (T)msgProps.getValue(name);
        }
        return null;
    }

    public static Date getStringDateProperty(Message<String> msg, String name, Date defaultDate) {
        IncomingAmqpMetadata meta = (IncomingAmqpMetadata)msg.getMetadata(IncomingAmqpMetadata.class).get();
        JsonObject msgProps = meta.getProperties();
        if (msgProps.containsKey(name)) {
            String tmp = msgProps.getString(name);
            return MessageUtil.stringToDate(tmp, defaultDate);
        }
        return null;
    }

    public static <T extends Enum<T>> T getEnumProperty(Message msg, String name, Class<T> clazz) {
        String tmp = (String)MessageUtil.getProperty(msg, name);
        if (tmp != null && !tmp.isEmpty()) {
            try {
                return Enum.valueOf(clazz, tmp);
            }
            catch (Exception ex) {
                log.error("Error parsing parameter {} as enumeration {} from the value {}", new Object[]{name, clazz.getName(), tmp});
                throw new RuntimeException("Not valid string for the enumeration.", ex);
            }
        }
        return null;
    }

    public static String serializeBody(Map<String, Object> data) throws IOException {
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        return WRITER.writeValueAsString(data);
    }

    public static <T> T deserialize(String data) {
        T result = null;
        if (data != null) {
            try {
                String tmp = "{\"value\":" + data + "}";
                Map r = (Map)READER.with(DeserializationFeature.USE_LONG_FOR_INTS).readValue(tmp);
                result = (T)r.get("value");
            }
            catch (Exception ex) {
                log.error("Error deserialize the value: " + data + ". Switch to the toString fallback!", (Throwable)ex);
            }
        }
        return result;
    }

    public static String serialize(Object data) {
        Object result = null;
        if (data != null) {
            try {
                result = WRITER.forType(data.getClass()).writeValueAsString(data);
            }
            catch (Exception ex) {
                log.error("Error serialize the value: " + data + ". Switch to the toString fallback!", (Throwable)ex);
                result = "" + data;
            }
        }
        return result;
    }

    public static Map<String, Object> deserializeBody(Message<String> message) throws IOException {
        String body;
        Map<String, Object> result = new HashMap<String, Object>();
        if (message != null && (body = (String)message.getPayload()) != null && !body.isEmpty()) {
            result = (Map)READER.with(DeserializationFeature.USE_LONG_FOR_INTS).readValue(body);
        }
        return result;
    }

    public static Date stringToDate(String value, Date defaultValue) {
        Date result = null;
        try {
            if (value != null && !value.isEmpty()) {
                SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSSZ");
                result = df.parse(value);
            }
        }
        catch (Exception ex) {
            log.warn("Error parsing the date {}. Switch to default value {}.", (Object)value, (Object)defaultValue);
            log.error("Error date parsing.", (Throwable)ex);
            result = defaultValue;
        }
        return result;
    }

    public static String dateToString(Date date) {
        if (date != null) {
            return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSSZ").format(date);
        }
        return null;
    }
}

