package org.tkit.rhpam.quarkus.rs.mappers;

import lombok.extern.slf4j.Slf4j;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

/**
 * @author Agnė Matusevičiūtė
 */
@Provider
@Slf4j
public class RhpamExceptionMapper implements ExceptionMapper<RhpamException> {

    @Override
    public Response toResponse(RhpamException exception) {
        return Response
                .status(exception.getStatus())
                .entity(exception.getMessage())
                .build();
    }
}
