package org.tkit.rhpam.quarkus.domain.models;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.Date;

/**
 * Stage flag representing simple information about process execution for given entity. See {@link DomainProcessInfo}.
 */
@Embeddable
@Getter
@Setter
public class StageFlag {
    @Temporal(TemporalType.TIMESTAMP)
    private Date date;
    @Enumerated(EnumType.STRING)
    private DomainProcessInfo.ProcessStatus status;
    private String info;
}
