/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.messaging.model;

import ext.api.centrallog.model.Severity;
import java.util.Map;
import org.tkit.rhpam.quarkus.common.MessageKeys;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecution;

public class AdditionalErrorInfo {
    private String errorCode;
    private String errorMessage;
    private String deepLink;
    private Severity messageSeverity;
    private ErrorSuppressionPolicy suppressErrorMessage;
    private Map<String, String> attributes;

    public static AdditionalErrorInfo createDefault(ProcessStepExecution workItem, Throwable exc) {
        RhpamException ee;
        AdditionalErrorInfoBuilder additionalErrorInfoBuilder = AdditionalErrorInfo.builder();
        if (exc instanceof RhpamException && (ee = (RhpamException)exc).getErrorCode() != null) {
            return additionalErrorInfoBuilder.errorCode(ee.getErrorCode()).errorMessage(ee.getErrorMessage()).build();
        }
        return additionalErrorInfoBuilder.errorCode(MessageKeys.TECHNICAL_ERROR_IN_STEP_EXEC.getErrorCode()).errorMessage(MessageKeys.TECHNICAL_ERROR_IN_STEP_EXEC.formatMessage(workItem.getName())).build();
    }

    private static Severity $default$messageSeverity() {
        return Severity.ERROR;
    }

    private static ErrorSuppressionPolicy $default$suppressErrorMessage() {
        return ErrorSuppressionPolicy.NEVER;
    }

    AdditionalErrorInfo(String errorCode, String errorMessage, String deepLink, Severity messageSeverity, ErrorSuppressionPolicy suppressErrorMessage, Map<String, String> attributes) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.deepLink = deepLink;
        this.messageSeverity = messageSeverity;
        this.suppressErrorMessage = suppressErrorMessage;
        this.attributes = attributes;
    }

    public static AdditionalErrorInfoBuilder builder() {
        return new AdditionalErrorInfoBuilder();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getDeepLink() {
        return this.deepLink;
    }

    public Severity getMessageSeverity() {
        return this.messageSeverity;
    }

    public ErrorSuppressionPolicy getSuppressErrorMessage() {
        return this.suppressErrorMessage;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setDeepLink(String deepLink) {
        this.deepLink = deepLink;
    }

    public void setMessageSeverity(Severity messageSeverity) {
        this.messageSeverity = messageSeverity;
    }

    public void setSuppressErrorMessage(ErrorSuppressionPolicy suppressErrorMessage) {
        this.suppressErrorMessage = suppressErrorMessage;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public static class AdditionalErrorInfoBuilder {
        private String errorCode;
        private String errorMessage;
        private String deepLink;
        private boolean messageSeverity$set;
        private Severity messageSeverity$value;
        private boolean suppressErrorMessage$set;
        private ErrorSuppressionPolicy suppressErrorMessage$value;
        private Map<String, String> attributes;

        AdditionalErrorInfoBuilder() {
        }

        public AdditionalErrorInfoBuilder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public AdditionalErrorInfoBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public AdditionalErrorInfoBuilder deepLink(String deepLink) {
            this.deepLink = deepLink;
            return this;
        }

        public AdditionalErrorInfoBuilder messageSeverity(Severity messageSeverity) {
            this.messageSeverity$value = messageSeverity;
            this.messageSeverity$set = true;
            return this;
        }

        public AdditionalErrorInfoBuilder suppressErrorMessage(ErrorSuppressionPolicy suppressErrorMessage) {
            this.suppressErrorMessage$value = suppressErrorMessage;
            this.suppressErrorMessage$set = true;
            return this;
        }

        public AdditionalErrorInfoBuilder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public AdditionalErrorInfo build() {
            Severity messageSeverity$value = this.messageSeverity$value;
            if (!this.messageSeverity$set) {
                messageSeverity$value = AdditionalErrorInfo.$default$messageSeverity();
            }
            ErrorSuppressionPolicy suppressErrorMessage$value = this.suppressErrorMessage$value;
            if (!this.suppressErrorMessage$set) {
                suppressErrorMessage$value = AdditionalErrorInfo.$default$suppressErrorMessage();
            }
            return new AdditionalErrorInfo(this.errorCode, this.errorMessage, this.deepLink, messageSeverity$value, suppressErrorMessage$value, this.attributes);
        }

        public String toString() {
            return "AdditionalErrorInfo.AdditionalErrorInfoBuilder(errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + ", deepLink=" + this.deepLink + ", messageSeverity$value=" + this.messageSeverity$value + ", suppressErrorMessage$value=" + this.suppressErrorMessage$value + ", attributes=" + this.attributes + ")";
        }
    }

    public static enum ErrorSuppressionPolicy {
        ALWAYS,
        NEVER,
        IF_RETRY_ALLOWED;

    }
}

