package org.tkit.rhpam.quarkus.domain.models;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * A history of all executed processes.
 */
@Entity
@Getter
@Setter
@Table(name = "pl_domain_process_history")
@ToString
public class DomainProcessHistory {

    @Data
    @Embeddable
    public static class PrimaryKey implements Serializable {
        /**
         * The domain reference.
         */
        @Column(name = "DOMAIN_REF")
        private String domainRef;

        /**
         * The process ID.
         */
        @Column(name = "PROCESS_ID")
        private String processId;

        /**
         * The instance ID.
         */
        @Column(name = "INSTANCE_ID")
        private String instanceId;
    }

    /**
     * The primary key.
     */
    @EmbeddedId PrimaryKey primaryKey;

    /**
     * The process status.
     */
    @Enumerated(EnumType.STRING)
    @Column(name = "STATUS")
    private DomainProcessInfo.ProcessStatus status;

    /**
     * The start timestamp.
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "START_TIMESTAMP")
    private Date startTimestamp;

    /**
     * The end timestamp.
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "END_TIMESTAMP")
    private Date endTimestamp;
}
