package org.tkit.rhpam.quarkus.messaging.model;

import ext.api.centrallog.model.Severity;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import org.tkit.rhpam.quarkus.common.MessageKeys;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;

import java.util.Map;

/**
 * The type Additional error info.
 */
@Builder()
@Getter
@Setter
public class AdditionalErrorInfo {

    private String errorCode;

    private String errorMessage;

    private String deepLink;

    @Builder.Default
    private Severity messageSeverity = Severity.ERROR;
    @Builder.Default
    private ErrorSuppressionPolicy suppressErrorMessage = ErrorSuppressionPolicy.NEVER;

    private Map<String,String> attributes;

    public static AdditionalErrorInfo createDefault(ProcessStepExecution workItem, Throwable exc) {
        AdditionalErrorInfo.AdditionalErrorInfoBuilder additionalErrorInfoBuilder = AdditionalErrorInfo.builder();
        if (exc instanceof RhpamException) {
            RhpamException ee = (RhpamException) exc;
            if (ee.getErrorCode() != null) {
                return additionalErrorInfoBuilder
                        .errorCode(ee.getErrorCode())
                        .errorMessage(ee.getErrorMessage())
                        .build();
            }
        }
        return additionalErrorInfoBuilder
                .errorCode(MessageKeys.TECHNICAL_ERROR_IN_STEP_EXEC.getErrorCode())
                .errorMessage(MessageKeys.TECHNICAL_ERROR_IN_STEP_EXEC.formatMessage(workItem.getName()))
                .build();
    }

    public enum ErrorSuppressionPolicy {
        ALWAYS,
        NEVER,
        IF_RETRY_ALLOWED
    }
}
