package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.Objects;


/**
 * The type Node event.
 */
public class NodeEvent extends ActivityEvent {
    private @Valid @NotNull
    String nodeId = null;

    /**
     * Node id node event.
     *
     * @param nodeId the node id
     * @return the node event
     */
    public NodeEvent nodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }


    /**
     * Gets node id.
     *
     * @return the node id
     */
    @JsonProperty("nodeId")

    public String getNodeId() {
        return nodeId;
    }

    /**
     * Sets node id.
     *
     * @param nodeId the node id
     */
    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        NodeEvent nodeEvent = (NodeEvent) o;
        return Objects.equals(nodeId, nodeEvent.nodeId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(nodeId);
    }

    @Override
    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NodeEvent {\n");
        sb.append("    ").append(toIndentedString(super.toPrettyString())).append("\n");
        sb.append("    nodeId: ").append(toIndentedString(nodeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

}
