package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.Valid;
import java.util.Objects;


/**
 * The type Node start event.
 */
public class NodeStartEvent extends NodeEvent {
    private @Valid
    NodeType nodeType = null;
    private @Valid
    String nodeName = null;

    /**
     * Node type node start event.
     *
     * @param nodeType the node type
     * @return the node start event
     */
    public NodeStartEvent nodeType(NodeType nodeType) {
        this.nodeType = nodeType;
        return this;
    }


    /**
     * Gets node type.
     *
     * @return the node type
     */
    @JsonProperty("nodeType")

    public NodeType getNodeType() {
        return nodeType;
    }

    /**
     * Sets node type.
     *
     * @param nodeType the node type
     */
    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    /**
     * Node name node start event.
     *
     * @param nodeName the node name
     * @return the node start event
     */
    public NodeStartEvent nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }


    /**
     * Gets node name.
     *
     * @return the node name
     */
    @JsonProperty("nodeName")

    public String getNodeName() {
        return nodeName;
    }

    /**
     * Sets node name.
     *
     * @param nodeName the node name
     */
    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        NodeStartEvent nodeStartEvent = (NodeStartEvent) o;
        return Objects.equals(nodeType, nodeStartEvent.nodeType) &&
                Objects.equals(nodeName, nodeStartEvent.nodeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(nodeType, nodeName);
    }

    @Override
    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NodeStartEvent {\n");
        sb.append("    ").append(toIndentedString(super.toPrettyString())).append("\n");
        sb.append("    nodeType: ").append(toIndentedString(nodeType)).append("\n");
        sb.append("    nodeName: ").append(toIndentedString(nodeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

}
