package org.tkit.rhpam.quarkus.messaging;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;

import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class MetricsService {

    private static final String FAILED_PROCESSES_COUNTER_ENABLED = "ORG_TKIT_RHPAM_FAILED_PROCESSES_COUNTER_ENABLED";
    private static final String RETRIED_PROCESSES_COUNTER_ENABLED = "ORG_TKIT_RHPAM_RETRIED_PROCESSES_COUNTER_ENABLED";

    private final MeterRegistry registry;

    MetricsService(MeterRegistry registry) {
        this.registry = registry;
    }

    public void incrementFailedStepCount(String processName, String processStepName) {
        if (isFailedProcessesCounterEnabled()) {
            registry.counter("failed.quarkus.processes", Tags.of("process_name", processName, "process_step_name", processStepName)).increment();
        }
    }

    public void incrementRetriedStepCount(String processName, String processStepName) {
        if (isRetriedProcessesCounterEnabled()) {
            registry.counter("retried.quarkus.processes", Tags.of("process_name", processName, "process_step_name", processStepName)).increment();
        }
    }

    private boolean isFailedProcessesCounterEnabled() {
        return Boolean.parseBoolean(System.getenv(FAILED_PROCESSES_COUNTER_ENABLED));
    }

    private boolean isRetriedProcessesCounterEnabled() {
        return Boolean.parseBoolean(System.getenv(RETRIED_PROCESSES_COUNTER_ENABLED));
    }
}

