/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.process;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.rhpam.quarkus.domain.daos.FailedStepDAO;
import org.tkit.rhpam.quarkus.domain.models.FailedStep;
import org.tkit.rhpam.quarkus.domain.models.FailedStepSearchCriteria;
import org.tkit.rhpam.quarkus.process.RetryStepService;

@ApplicationScoped
@Transactional
public class ResolveStepService {
    private static final Logger log = LoggerFactory.getLogger(ResolveStepService.class);
    @Inject
    FailedStepDAO failedStepDAO;
    @Inject
    RetryStepService retryStepService;

    public void resolveBusinessFailedSteps(Long processInstanceId, String resolutionOption, String resolutionSource, String processStepName) throws Exception {
        List<FailedStep> failedSteps = this.findOpenBusinessFailedSteps(processInstanceId, processStepName);
        for (FailedStep failedStep : failedSteps) {
            this.retryStepService.resolveFailedStep(failedStep.getId(), resolutionOption, resolutionSource);
            log.info("Business failed steps connected with processId: {} and processInstanceId: {} were resolved successfully", (Object)failedStep.getProcessId(), (Object)processInstanceId);
        }
    }

    private List<FailedStep> findOpenBusinessFailedSteps(Long processInstanceId, String processStepName) {
        FailedStepSearchCriteria criteria = new FailedStepSearchCriteria();
        criteria.setProcessInstanceId(processInstanceId);
        criteria.setFailureType(FailedStep.FailureType.BUSINESS_ERROR);
        criteria.setStatus(FailedStep.FailedStepStatus.OPEN);
        criteria.setProcessStepName(processStepName);
        return this.failedStepDAO.findBySearchCriteria(criteria);
    }
}

