/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.tracing;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.tkit.rhpam.quarkus.tracing.HeadersMapExtractAdapter;
import org.tkit.rhpam.quarkus.tracing.HeadersMapInjectAdapter;

public class TracingUtils {
    public static SpanContext extract(JsonObject props, Tracer tracer) {
        SpanContext spanContext = tracer.extract(Format.Builtin.TEXT_MAP, (Object)new HeadersMapExtractAdapter(props.getMap()));
        if (spanContext != null) {
            return spanContext;
        }
        Span span = tracer.activeSpan();
        if (span != null) {
            return span.context();
        }
        return null;
    }

    public static Span buildChildSpan(String spanName, JsonObject props, Tracer tracer) {
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(spanName).withTag(Tags.SPAN_KIND.getKey(), "consumer");
        SpanContext parentContext = TracingUtils.extract(props, tracer);
        if (parentContext != null) {
            spanBuilder.addReference("child_of", parentContext);
        }
        Span span = spanBuilder.start();
        try {
            if (props.getMap() != null) {
                tracer.inject(span.context(), Format.Builtin.TEXT_MAP, (Object)new HeadersMapInjectAdapter(props.getMap()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return span;
    }

    public static Span buildChildSpan2(String spanName, JsonObject props, Tracer tracer) {
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(spanName).withTag(Tags.SPAN_KIND.getKey(), "consumer");
        Span ctxParentSpan = tracer.activeSpan();
        if (ctxParentSpan != null) {
            spanBuilder.addReference("follows_from", ctxParentSpan.context());
        }
        Span span = spanBuilder.start();
        return span;
    }

    public static Span buildSpan(String exchange, String routingKey, ApplicationProperties props, Tracer tracer) {
        Span parentSpan;
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan("send").ignoreActiveSpan().withTag(Tags.SPAN_KIND.getKey(), "producer").withTag("routingKey", routingKey);
        SpanContext spanContext = null;
        if (props != null && props.getValue() != null) {
            spanContext = tracer.extract(Format.Builtin.TEXT_MAP, (Object)new HeadersMapExtractAdapter(props.getValue()));
        }
        if (spanContext == null && (parentSpan = tracer.activeSpan()) != null) {
            spanContext = parentSpan.context();
        }
        if (spanContext != null) {
            spanBuilder.asChildOf(spanContext);
        }
        Span span = spanBuilder.start();
        return span;
    }

    public static Map<String, Object> inject(Map<String, Object> props, Span span, Tracer tracer) {
        if (props == null) {
            props = new HashMap<String, Object>();
        }
        tracer.inject(span.context(), Format.Builtin.TEXT_MAP, (Object)new HeadersMapInjectAdapter(props));
        return props;
    }
}

