package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;

public class ProcessEventTypeResolver extends TypeIdResolverBase {
    @Override
    public String idFromValue(Object value) {
        return idFromValueAndType(value, value.getClass());
    }

    @Override
    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return ((ProcessLogEvent) value).getProcessEventType().name();
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    @Override
    public JavaType typeFromId(DatabindContext context, String id) {
        Class<?> subType = null;
        EventType eventType = EventType.valueOf(id);
        switch (eventType) {
            case PROCESS_START_EVENT:
                subType = ProcessStartEvent.class;
                break;
            case PROCESS_END_EVENT:
                subType = ProcessEndEvent.class;
                break;
            case NODE_START_EVENT:
                subType = NodeStartEvent.class;
                break;
            case NODE_END_EVENT:
                subType = NodeEndEvent.class;
                break;
            case MESSAGE_EVENT:
                subType = MessageEvent.class;
                break;
            case OPEN_INCIDENT_EVENT:
                subType = OpenIncidentEvent.class;
                break;
            case RESOLVED_INCIDENT_EVENT:
                subType = ResolvedIncidentEvent.class;
                break;
            default:
                throw new IllegalStateException("Unexpected value: " + id);
        }
        return context.constructType(subType);
    }


}
