package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets Severity
 */
public enum Severity {
    /**
     * Info severity.
     */
    INFO("INFO"),
    /**
     * Warn severity.
     */
    WARN("WARN"),
    /**
     * Error severity.
     */
    ERROR("ERROR");

    private String value;

    Severity(String value) {
        this.value = value;
    }

    /**
     * From value severity.
     *
     * @param text the text
     * @return the severity
     */
    @JsonCreator
    public static Severity fromValue(String text) {
        for (Severity b : Severity.values()) {
            if (String.valueOf(b.value).equals(text)) {
                return b;
            }
        }
        return null;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }
}
