package org.tkit.rhpam.quarkus.messaging.duplicate;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * Utility class to support creation of unique duplicate detection keys
 */
public class DuplicateDetectionIdGenerator {

    /**
     * The most basic duplication detection id is based on full business process context and midnight marker
     *
     * @param deploymentId the deployment ID.
     * @param processId    the ID of the process
     * @param referenceBid business reference bid to be defined in the step logs
     * @param referenceKey the reference key.
     *
     * @return upper case concatenation of above
     */
    public static String get(String deploymentId, String processId, Object referenceBid, String referenceKey) {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String midnightString = now.format(formatter);

        return (deploymentId + "_" + processId + "_" + referenceBid  + "_" +  referenceKey + "_" + midnightString).toUpperCase();
    }
}
