/*
 * Copyright (c) 2018, 1000kit.org, and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.tkit.rhpam.quarkus.messaging.model;

import lombok.Builder;
import lombok.Getter;
import lombok.ToString;

import java.util.Date;
import java.util.Map;

/**
 * The process engine log item.
 */
@Getter
@ToString(callSuper = true)
public class ProcessEventItem extends AbstractProcessItem {

    /**
     * The process event type.
     */
    private ProcessEventType processEventType;

    private String outcome;

    private boolean error;

    private String nodeResolutionStatus;

    private String correlationId;

    private Long subProcessId;

    /**
     * The listener type.
     */
    @ToString.Exclude
    private String listenerType;

    /**
     * The default constructor.
     *
     * @param timerId                 the timer id.
     * @param workItemId              the work item id.
     * @param executionId             the execution id.
     * @param nodeType                the node type.
     * @param referenceBid            the reference bid.
     * @param referenceKey            the reference key.
     * @param processEventType        the process event type.
     * @param listenerType            the listener type.
     * @param body                    the body.
     * @param processLogGuid          the process log guid.
     * @param processId               the process id.
     * @param processName             the process name.
     * @param processVersion          the process version.
     * @param processInstanceId       the process instance id.
     * @param executionDate           the execution date.
     * @param deploymentId            the deployment id.
     * @param name                    the node name.
     * @param nodeId                  the node id.
     * @param parentProcessInstanceId the parent process instance id.
     * @param boundaryEventId         the boundary event id.
     * @param parameters              the parameters.
     * @param outcome                 the outcome
     * @param error                   the error
     * @param nodeResolutionStatus    nodeResolutionStatus
     * @param parentProcessId         the parent process id
     * @param correlationId           the correlation id
     * @param subProcessId            the sub process id
     */
    @Builder
    public ProcessEventItem(Long timerId, Long workItemId, Long executionId, NodeType nodeType, Object referenceBid, String referenceKey, ProcessEventType processEventType, String listenerType, String body, String processLogGuid, String processId, String processName, String processVersion, Long processInstanceId, Date executionDate, String deploymentId, String name, Long nodeId, Long parentProcessInstanceId, String boundaryEventId, Map<String, Object> parameters, String outcome, boolean error, String nodeResolutionStatus, String parentProcessId, String correlationId, Long subProcessId, ProcessState processState) {
        super(processLogGuid, executionId, timerId, workItemId, body, nodeType, referenceBid, referenceKey, processId, processName, processVersion, processInstanceId, executionDate, deploymentId, name, nodeId, parentProcessInstanceId, boundaryEventId, parameters, parentProcessId, processState);
        this.listenerType = listenerType;
        this.processEventType = processEventType;
        this.error = error;
        this.outcome = outcome;
        this.nodeResolutionStatus = nodeResolutionStatus;
        this.correlationId = correlationId;
        this.subProcessId = subProcessId;
    }
}
