package org.tkit.rhpam.quarkus.process;

import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Qualifier;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * The interface Business process.
 */
@Qualifier
@Inherited
@Target({ TYPE, METHOD, FIELD, PARAMETER })
@Retention(RUNTIME)
public @interface BusinessProcess {
    /**
     * Value string.
     *
     * @return the string
     */
    String value();

    /**
     * The type Literal.
     */
    class Literal extends AnnotationLiteral<BusinessProcess> implements BusinessProcess {

        private final String value;

        /**
         * Instantiates a new Literal.
         *
         * @param value the value
         */
        public Literal(String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return value;
        }
    }
}
