/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.messaging;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class MetricsService {
    private static final String FAILED_PROCESSES_COUNTER_ENABLED = "ORG_TKIT_RHPAM_FAILED_PROCESSES_COUNTER_ENABLED";
    private static final String RETRIED_PROCESSES_COUNTER_ENABLED = "ORG_TKIT_RHPAM_RETRIED_PROCESSES_COUNTER_ENABLED";
    private final MeterRegistry registry;

    MetricsService(MeterRegistry registry) {
        this.registry = registry;
    }

    public void incrementFailedStepCount(String processName, String processStepName) {
        if (this.isFailedProcessesCounterEnabled()) {
            this.registry.counter("failed.quarkus.processes", (Iterable)Tags.of((String[])new String[]{"process_name", processName, "process_step_name", processStepName})).increment();
        }
    }

    public void incrementRetriedStepCount(String processName, String processStepName) {
        if (this.isRetriedProcessesCounterEnabled()) {
            this.registry.counter("retried.quarkus.processes", (Iterable)Tags.of((String[])new String[]{"process_name", processName, "process_step_name", processStepName})).increment();
        }
    }

    private boolean isFailedProcessesCounterEnabled() {
        return Boolean.parseBoolean(System.getenv(FAILED_PROCESSES_COUNTER_ENABLED));
    }

    private boolean isRetriedProcessesCounterEnabled() {
        return Boolean.parseBoolean(System.getenv(RETRIED_PROCESSES_COUNTER_ENABLED));
    }
}

