/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.domain.daos;

import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.eclipse.microprofile.opentracing.Traced;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.rhpam.quarkus.domain.models.DomainProcessHistory;
import org.tkit.rhpam.quarkus.domain.models.DomainProcessInfo;

@ApplicationScoped
@Traced
@Transactional
public class DomainProcessHistoryDAO {
    private static final Logger log = LoggerFactory.getLogger(DomainProcessHistoryDAO.class);
    @PersistenceContext
    private EntityManager em;

    @Transactional(value=Transactional.TxType.REQUIRED)
    public void logProcessStart(String domainRef, String processId, String instanceId) {
        DomainProcessHistory.PrimaryKey primaryKey = new DomainProcessHistory.PrimaryKey();
        primaryKey.setDomainRef(domainRef);
        primaryKey.setProcessId(processId);
        primaryKey.setInstanceId(instanceId);
        DomainProcessHistory domainProcessHistory = new DomainProcessHistory();
        domainProcessHistory.setPrimaryKey(primaryKey);
        domainProcessHistory.setStatus(DomainProcessInfo.ProcessStatus.RUNNING);
        domainProcessHistory.setStartTimestamp(new Date());
        this.em.persist((Object)domainProcessHistory);
        this.em.flush();
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public void logProcessEnd(String domainRef, String processId, String instanceId, DomainProcessInfo.ProcessStatus processStatus) {
        try {
            DomainProcessHistory domainProcessHistory = (DomainProcessHistory)this.em.createQuery("SELECT dph FROM DomainProcessHistory dph WHERE dph.primaryKey.domainRef = :domainRef and dph.primaryKey.processId = :processId and dph.primaryKey.instanceId = :instanceId", DomainProcessHistory.class).setParameter("domainRef", (Object)domainRef).setParameter("processId", (Object)processId).setParameter("instanceId", (Object)instanceId).setLockMode(LockModeType.PESSIMISTIC_WRITE).getSingleResult();
            domainProcessHistory.setStatus(processStatus);
            domainProcessHistory.setEndTimestamp(new Date());
            this.em.merge((Object)domainProcessHistory);
            this.em.flush();
        }
        catch (NoResultException nre) {
            log.error("No Domain Process History was found for Process ID {}, Instance ID {}, Domain Reference {} on process end.", new Object[]{processId, instanceId, domainRef});
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public List<DomainProcessHistory> find(String domainRefKey, String domainRefId, String processId, DomainProcessInfo.ProcessStatus status) {
        return this.em.createQuery("SELECT dph FROM DomainProcessHistory dph WHERE dph.primaryKey.domainRef = :domainRef and dph.primaryKey.processId = :processId and dph.status = :status", DomainProcessHistory.class).setParameter("domainRef", (Object)(domainRefKey + "#" + domainRefId)).setParameter("processId", (Object)processId).setParameter("status", (Object)status).getResultList();
    }
}

