/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.messaging;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.opentracing.Traced;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.quarkus.log.cdi.LogService;
import org.tkit.rhpam.quarkus.common.MessageKeys;
import org.tkit.rhpam.quarkus.domain.models.FailedStep;
import org.tkit.rhpam.quarkus.messaging.FailedStepService;
import org.tkit.rhpam.quarkus.messaging.MetricsService;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;
import org.tkit.rhpam.quarkus.messaging.model.AdditionalErrorInfo;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecution;
import org.tkit.rhpam.quarkus.messaging.model.ProcessStepExecutionResult;
import org.tkit.rhpam.quarkus.messaging.model.ResolutionStatus;
import org.tkit.rhpam.quarkus.process.ProcessStepService;

@ApplicationScoped
@Traced
public class BusinessErrorHandlerStepService
implements ProcessStepService {
    private static final Logger log = LoggerFactory.getLogger(BusinessErrorHandlerStepService.class);
    @Inject
    FailedStepService failedStepService;
    @Inject
    MetricsService metricsService;

    @Override
    @LogService(stacktrace=false)
    public ProcessStepExecutionResult doExecute(ProcessStepExecution workItem) throws RhpamException {
        String referencedStepName = (String)workItem.getParameter("referencedStepId");
        String resolutionSignalId = (String)workItem.getParameter("resolutionSignalId");
        String resolutionActions = (String)workItem.getParameter("resolutionActions");
        if (referencedStepName == null || resolutionSignalId == null || resolutionActions == null) {
            log.error("Invalid business error handler definition! Please specify all of {referencedStepName,resolutionSignalId,resolutionActions}");
        }
        FailedStep failedStep = this.failedStepService.updateFailedStep(workItem, referencedStepName, resolutionActions, resolutionSignalId);
        this.failedStepService.emitFailedStepEvent(failedStep);
        if (failedStep.getExecutionCount() == null || failedStep.getExecutionCount() == 0) {
            this.metricsService.incrementFailedStepCount(failedStep.getProcessName(), failedStep.getProcessStepName());
        }
        return ProcessStepExecutionResult.builder().status(ResolutionStatus.SUCCESSFUL).build();
    }

    @Override
    public AdditionalErrorInfo provideErrorInformation(ProcessStepExecution workItem, Exception exc) {
        if (exc instanceof RhpamException && ((RhpamException)exc).getErrorCode().equals(MessageKeys.BUSINESS_ERR_HANDLER_MISSING_FAILED_STEP.getErrorCode())) {
            AdditionalErrorInfo aei = ProcessStepService.super.provideErrorInformation(workItem, exc);
            aei.setSuppressErrorMessage(AdditionalErrorInfo.ErrorSuppressionPolicy.IF_RETRY_ALLOWED);
            return aei;
        }
        return ProcessStepService.super.provideErrorInformation(workItem, exc);
    }
}

