/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.process;

import io.jaegertracing.internal.JaegerSpanContext;
import io.opentracing.Tracer;
import io.smallrye.reactive.messaging.amqp.OutgoingAmqpMetadata;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.quarkus.log.cdi.context.TkitLogContext;
import org.tkit.rhpam.quarkus.domain.daos.DomainProcessInfoDAO;
import org.tkit.rhpam.quarkus.domain.models.DomainProcessInfo;
import org.tkit.rhpam.quarkus.messaging.common.MessageUtil;
import org.tkit.rhpam.quarkus.messaging.common.RhpamException;
import org.tkit.rhpam.quarkus.messaging.emitters.JbpmMessageEmitter;
import org.tkit.rhpam.quarkus.messaging.model.CommandType;
import org.tkit.rhpam.quarkus.rs.clients.KieServerRestClient;
import org.tkit.rhpam.quarkus.tracing.TracingUtils;

@ApplicationScoped
@Transactional(value=Transactional.TxType.REQUIRED)
@Traced
public class ProcessService {
    private static final Logger log = LoggerFactory.getLogger(ProcessService.class);
    @Inject
    DomainProcessInfoDAO domainProcessInfoDAO;
    @Inject
    JbpmMessageEmitter jbpmMessageEmitter;
    @Inject
    Tracer configuredTracer;
    @ConfigProperty(name="kie.admin.user")
    private Optional<String> usernameParam;
    @ConfigProperty(name="kie.admin.pwd")
    private Optional<String> passwordParam;
    @Inject
    @RestClient
    KieServerRestClient kieServerRestClient;

    public String startProcess(String deploymentId, String processId, Object referenceBid, String referenceKey, Map<String, Object> data) throws RhpamException {
        try {
            HashMap<String, Object> tracingMeta = new HashMap<String, Object>();
            if (this.configuredTracer != null) {
                TracingUtils.inject(tracingMeta, this.configuredTracer.activeSpan(), this.configuredTracer);
                JaegerSpanContext spanContext = (JaegerSpanContext)this.configuredTracer.activeSpan().context();
                data.put("TRACE_ID", spanContext.getTraceId());
            }
            if (TkitLogContext.get() != null) {
                data.put("X_CORRELATION_ID", TkitLogContext.get().correlationId);
            }
            String parameters = MessageUtil.serializeBody(data);
            this.updateDomainProcessInfo(processId, referenceBid, referenceKey);
            String guid = UUID.randomUUID().toString();
            OutgoingAmqpMetadata meta = OutgoingAmqpMetadata.builder().withMessageId(UUID.randomUUID().toString()).withCreationTime(new Date().getTime()).withApplicationProperties(JsonObject.mapFrom(tracingMeta)).withApplicationProperty("TKIT_DEPLOYMENT_ID", (Object)deploymentId).withApplicationProperty("TKIT_PROCESS_LOG_GUID", (Object)guid).withApplicationProperty("TKIT_REFERENCE_BID", referenceBid).withApplicationProperty("TKIT_REFERENCE_KEY", (Object)referenceKey).withApplicationProperty("TKIT_PROCESS_ID", (Object)processId).withApplicationProperty("TKIT_CMD", (Object)CommandType.START_PROCESS.name()).build();
            Message toEmit = Message.of((Object)parameters, (Metadata)Metadata.of((Object[])new Object[]{meta}), () -> CompletableFuture.completedFuture(null));
            this.jbpmMessageEmitter.emit((Message<String>)toEmit);
            return guid;
        }
        catch (Exception ex) {
            throw new RhpamException(ErrorKeys.ERROR_START_PROCESS.name(), ex);
        }
    }

    public long startProcessSync(String deploymentId, String processId, Object referenceBid, String referenceKey, Map<String, Object> data) throws RhpamException {
        try {
            HashMap<String, Object> tracingMeta = new HashMap<String, Object>();
            if (this.configuredTracer != null) {
                TracingUtils.inject(tracingMeta, this.configuredTracer.activeSpan(), this.configuredTracer);
                JaegerSpanContext spanContext = (JaegerSpanContext)this.configuredTracer.activeSpan().context();
                data.put("TRACE_ID", spanContext.getTraceId());
            }
            if (TkitLogContext.get() != null) {
                data.put("X_CORRELATION_ID", TkitLogContext.get().correlationId);
            }
            this.updateDomainProcessInfo(processId, referenceBid, referenceKey);
            String guid = UUID.randomUUID().toString();
            data.put("TKIT_REFERENCE_KEY", referenceKey);
            data.put("TKIT_REFERENCE_BID", referenceBid);
            data.put("TKIT_DEPLOYMENT_ID", deploymentId);
            data.put("TKIT_PROCESS_ID", processId);
            data.put("TKIT_PROCESS_LOG_GUID", guid);
            data.putAll(tracingMeta);
            String username = this.usernameParam.map(Object::toString).orElseThrow(() -> new RhpamException("Kie server username can not be null. Please provide property kie.admin.user with correct value", Response.Status.BAD_REQUEST));
            String password = this.passwordParam.map(Object::toString).orElseThrow(() -> new RhpamException("Kie server password can not be null.Please provide property kie.admin.pwd with correct value", Response.Status.BAD_REQUEST));
            String authentication = this.getClientCredentialsAuth(username, password);
            return this.kieServerRestClient.startProcessInstance(authentication, deploymentId, processId, data);
        }
        catch (WebApplicationException wae) {
            String err = (String)wae.getResponse().readEntity(String.class);
            log.error("Error response from kieserver : {} body {}", (Object)wae.getResponse().getStatus(), (Object)err);
            throw new RhpamException(ErrorKeys.ERROR_START_PROCESS.name(), wae);
        }
        catch (Exception ex) {
            throw new RhpamException(ErrorKeys.ERROR_START_PROCESS.name(), ex);
        }
    }

    private String getClientCredentialsAuth(String username, String password) {
        String tmp = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(tmp.getBytes(StandardCharsets.UTF_8));
    }

    public void sendMessage(String deploymentId, Long processInstanceId, String messageId, Object data) throws RhpamException {
        this.sendSignal(deploymentId, processInstanceId, "Message-" + messageId, data);
    }

    public void sendSignal(String deploymentId, Long processInstanceId, String signalId, Object data) throws RhpamException {
        try {
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            if (data != null) {
                tmp.put("TKIT_SIGNAL_DATA", data);
            }
            String parameters = MessageUtil.serializeBody(tmp);
            Message toEmit = Message.of((Object)parameters);
            OutgoingAmqpMetadata meta = OutgoingAmqpMetadata.builder().withApplicationProperty("TKIT_DEPLOYMENT_ID", (Object)deploymentId).withApplicationProperty("TKIT_PROCESS_INSTANCE_ID", (Object)processInstanceId).withApplicationProperty("TKIT_SIGNAL", (Object)signalId).withApplicationProperty("TKIT_CMD", (Object)CommandType.SEND_SIGNAL.name()).build();
            toEmit = toEmit.addMetadata((Object)meta);
            this.jbpmMessageEmitter.emit((Message<String>)toEmit);
        }
        catch (Exception ex) {
            throw new RhpamException(ErrorKeys.ERROR_SEND_SIGNAL.name(), ex);
        }
    }

    private void updateDomainProcessInfo(String processId, Object referenceBid, String referenceKey) {
        DomainProcessInfo dpi = this.domainProcessInfoDAO.selectForUpdate(referenceKey, String.valueOf(referenceBid));
        if (dpi == null) {
            dpi = new DomainProcessInfo(referenceKey, String.valueOf(referenceBid));
        }
        dpi.setCurrentProcessId(processId);
        dpi.setCurrentProcessStartTime(new Date());
        dpi.setCurrentProcessStatus(DomainProcessInfo.ProcessStatus.PENDING);
        dpi.setProcessActive(true);
        dpi.setCurrentProcessStepName(null);
        dpi.setCurrentProcessStepStatus(null);
        this.domainProcessInfoDAO.update(dpi);
    }

    static enum ErrorKeys {
        ERROR_START_PROCESS,
        ERROR_SEND_SIGNAL;

    }
}

