/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.tracing;

import io.opentracing.propagation.TextMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HeadersMapExtractAdapter
implements TextMap {
    private final Map<String, String> map = new HashMap<String, String>();

    public HeadersMapExtractAdapter(Map<String, Object> headers) {
        if (headers == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            this.map.put(this.decodeDash(entry.getKey()), String.valueOf(entry.getValue()));
        }
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return this.map.entrySet().iterator();
    }

    public void put(String key, String value) {
        throw new UnsupportedOperationException("HeadersMapExtractAdapter should only be used with Tracer.extract()");
    }

    private String decodeDash(String key) {
        return key.replace("_$dash$_", "-");
    }
}

