package ext.api.centrallog.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets NodeType
 */
public enum NodeType {
    /**
     * Activity node type.
     */
    ACTIVITY("ACTIVITY"),
    /**
     * Event node type.
     */
    EVENT("EVENT"),
    /**
     * Gateway node type.
     */
    GATEWAY("GATEWAY"),
    /**
     * Human task node type.
     */
    HUMAN_TASK("HUMAN_TASK"),
    /**
     * Other node type.
     */
    OTHER("OTHER"),
    /**
     * Process end node type.
     */
    PROCESS_END("PROCESS_END"),
    /**
     * Process start node type.
     */
    PROCESS_START("PROCESS_START"),
    /**
     * Sub process node type.
     */
    SUB_PROCESS("SUB_PROCESS"),
    /**
     * Timer node type.
     */
    TIMER("TIMER");

    private String value;

    NodeType(String value) {
        this.value = value;
    }

    /**
     * From value node type.
     *
     * @param text the text
     * @return the node type
     */
    @JsonCreator
    public static NodeType fromValue(String text) {
        for (NodeType b : NodeType.values()) {
            if (String.valueOf(b.value).equals(text)) {
                return b;
            }
        }
        return null;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }
}
