package org.tkit.rhpam.quarkus.rs.clients;

import io.quarkus.runtime.annotations.RegisterForReflection;
import org.eclipse.microprofile.rest.client.annotation.RegisterClientHeaders;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;

import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.*;
import javax.ws.rs.core.Response;
import java.util.List;
import java.util.Map;

/**
 * @author Agnė Matusevičiūtė
 */
@Path("/server")
@ApplicationScoped
@RegisterForReflection
@RegisterRestClient(configKey = "rest-api-kie-server")
@RegisterClientHeaders
public interface KieServerRestClient {

    @POST
    @Path("/containers/{containerId}/processes/{processId}/instances")
    long startProcessInstance(@HeaderParam("Authorization") String basicAuthToken, @PathParam("containerId") String containerId, @PathParam("processId") String processId, Map<String, Object> params);

    @GET
    @Path("/containers/{containerId}/processes/instances/{processInstanceId}")
    Response getProcessInstance(@HeaderParam("Authorization") String basicAuthToken, @PathParam("containerId") String containerId, @PathParam("processInstanceId") Long processInstanceId);

    @GET
    @Path("/containers/{containerId}/processes/instances/{processInstanceId}/processes")
    Response getProcessInstances(@HeaderParam("Authorization") String basicAuthToken, @PathParam("containerId") String containerId, @PathParam("processInstanceId") Long processInstanceId);

    @DELETE
    @Path("/containers/{containerId}/processes/instances/{processInstanceId}")
    Response abortProcessInstance(@HeaderParam("Authorization") String basicAuthToken, @PathParam("containerId") String containerId, @PathParam("processInstanceId") Long processInstanceId);

    @DELETE
    @Path("/containers/{containerId}/processes/instances")
    Response abortProcessInstances(@HeaderParam("Authorization") String basicAuthToken, @PathParam("containerId") String containerId, @QueryParam("instanceId") List<Long> processInstanceIds);
}

