/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.domain.daos;

import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.eclipse.microprofile.opentracing.Traced;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.rhpam.quarkus.domain.models.DomainProcessInfo;
import org.tkit.rhpam.quarkus.domain.models.StageFlag;

@ApplicationScoped
@Traced
@Transactional
public class DomainProcessInfoDAO {
    private static final Logger log = LoggerFactory.getLogger(DomainProcessInfoDAO.class);
    @PersistenceContext
    private EntityManager em;

    @Transactional(value=Transactional.TxType.NOT_SUPPORTED)
    public DomainProcessInfo find(String domainRefKey, String domainRefId) {
        String id = domainRefKey + "#" + domainRefId;
        try {
            return (DomainProcessInfo)this.em.createQuery("select dpi from DomainProcessInfo dpi left join fetch dpi.stageFlags where dpi.id = :id", DomainProcessInfo.class).setParameter("id", (Object)id).getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    @Transactional(value=Transactional.TxType.NOT_SUPPORTED)
    public DomainProcessInfo find(Long processInstanceId) {
        try {
            return (DomainProcessInfo)this.em.createQuery("select dpi from DomainProcessInfo dpi left join fetch dpi.stageFlags where dpi.currentProcessInstanceId = :processInstanceId", DomainProcessInfo.class).setParameter("processInstanceId", (Object)processInstanceId).getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    @Transactional(value=Transactional.TxType.NOT_SUPPORTED)
    public List<DomainProcessInfo> find(List<Long> processInstanceIds) {
        if (processInstanceIds.size() > 1000) {
            log.warn("Fetching with big number of processInstanceIds {}, it might have a bad impact on performance", (Object)processInstanceIds.size());
        }
        return this.em.createQuery("select dpi from DomainProcessInfo dpi left join fetch dpi.stageFlags where dpi.currentProcessInstanceId in :processInstanceIds", DomainProcessInfo.class).setParameter("processInstanceIds", processInstanceIds).getResultList();
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public DomainProcessInfo selectForUpdate(String domainRefKey, String domainRefId) {
        String id = domainRefKey + "#" + domainRefId;
        try {
            return (DomainProcessInfo)this.em.createQuery("select dpi from DomainProcessInfo dpi left join fetch dpi.stageFlags where dpi.id = :id", DomainProcessInfo.class).setParameter("id", (Object)id).setLockMode(LockModeType.PESSIMISTIC_WRITE).getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public DomainProcessInfo selectForUpdate(String domainRefKey, String domainRefId, String processId) {
        String id = domainRefKey + "#" + domainRefId;
        try {
            return (DomainProcessInfo)this.em.createQuery("select dpi from DomainProcessInfo dpi left join fetch dpi.stageFlags where dpi.id = :id AND dpi.currentProcessId = :processId", DomainProcessInfo.class).setParameter("id", (Object)id).setParameter("processId", (Object)processId).setLockMode(LockModeType.PESSIMISTIC_WRITE).getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public DomainProcessInfo selectForUpdate(Long processInstanceId) {
        try {
            return (DomainProcessInfo)this.em.createQuery("select dpi from DomainProcessInfo dpi left join fetch dpi.stageFlags where dpi.currentProcessInstanceId = :processInstanceId", DomainProcessInfo.class).setParameter("processInstanceId", (Object)processInstanceId).setLockMode(LockModeType.PESSIMISTIC_WRITE).getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public void delete(DomainProcessInfo domainProcessInfo) {
        this.em.remove((Object)domainProcessInfo);
        this.em.flush();
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public DomainProcessInfo update(DomainProcessInfo toUpdate) {
        toUpdate = (DomainProcessInfo)this.em.merge((Object)toUpdate);
        this.em.flush();
        return toUpdate;
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public DomainProcessInfo addStageFlag(String domainRefKey, String domainRefId, String flagName, Date date, String info) {
        DomainProcessInfo dpi = this.selectForUpdate(domainRefKey, domainRefId);
        StageFlag stageFlag = new StageFlag();
        stageFlag.setDate(date);
        stageFlag.setInfo(info);
        dpi.getStageFlags().put(flagName, stageFlag);
        return this.update(dpi);
    }
}

