package org.tkit.rhpam.quarkus.tracing;

import io.opentracing.propagation.TextMap;

import java.util.Iterator;
import java.util.Map;


public class HeadersMapInjectAdapter implements TextMap {
    static final String DASH = "_$dash$_";
    private final Map<String, Object> params;

    public HeadersMapInjectAdapter(Map<String, Object> params) {
        this.params = params;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        throw new UnsupportedOperationException("iterator should never be used with Tracer.inject()");
    }

    @Override
    public void put(String key, String value) {
        if (params == null) {
            return;
        }
        params.put(encodeDash(key), value);
    }

    /**
     * Encode all dashes because JMS specification doesn't allow them in property name
     */
    private String encodeDash(String key) {
        if (key == null || key.isEmpty()) {
            return key;
        }

        return key.replace("-", DASH);
    }
}