/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.quarkus.messaging;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.rhpam.quarkus.domain.daos.DomainProcessInfoDAO;
import org.tkit.rhpam.quarkus.domain.models.DomainProcessInfo;
import org.tkit.rhpam.quarkus.domain.models.FailedStep;
import org.tkit.rhpam.quarkus.messaging.FailedStepService;
import org.tkit.rhpam.quarkus.messaging.MetricsService;
import org.tkit.rhpam.quarkus.tracing.TraceFromMessage;

@Transactional
@ApplicationScoped
public class TechnicalErrorFailedStepListener {
    private static final Logger log = LoggerFactory.getLogger(TechnicalErrorFailedStepListener.class);
    @Inject
    FailedStepService service;
    @Inject
    MetricsService metricsService;
    @Inject
    Tracer configuredTracer;
    @Inject
    ThreadContext threadContext;
    @Inject
    DomainProcessInfoDAO domainProcessInfoDAO;
    @Inject
    ManagedExecutor managedExecutor;

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    @Acknowledgment(value=Acknowledgment.Strategy.MANUAL)
    @Incoming(value="tkitrhpamfailedsteps")
    @TraceFromMessage
    public CompletionStage<Void> onFailedStepMessage(AmqpMessage<String> message) {
        Span span = this.configuredTracer.activeSpan().setOperationName("onFailedStepMessage");
        return this.threadContext.withContextCapture(CompletableFuture.runAsync(() -> {
            try (Scope scope = this.configuredTracer.scopeManager().activate(span, false);){
                DomainProcessInfo dpi;
                FailedStep failedStep = this.service.createOrUpdateFailedStep((Message<String>)message);
                this.service.emitFailedStepEvent(failedStep);
                if (failedStep.getExecutionCount() == null || failedStep.getExecutionCount() == 0) {
                    this.metricsService.incrementFailedStepCount(failedStep.getProcessName(), failedStep.getProcessStepName());
                }
                if ((dpi = this.domainProcessInfoDAO.selectForUpdate(failedStep.getReferenceKey(), String.valueOf(failedStep.getReferenceBid()))) != null) {
                    dpi.setCurrentProcessStepStatus(DomainProcessInfo.ProcessStatus.ERROR.name());
                    dpi.setCurrentProcessStatus(DomainProcessInfo.ProcessStatus.ERROR);
                    dpi.setCurrentProcessStepName(failedStep.getProcessStepName());
                    this.domainProcessInfoDAO.update(dpi);
                }
                message.ack();
            }
            catch (Exception e) {
                message.nack((Throwable)e);
            }
        }, (Executor)this.managedExecutor));
    }
}

