/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.rhpam.listener;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.server.api.KieServerEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.rhpam.task.model.AdditionContentDTO;
import org.tkit.rhpam.task.model.CreateTaskRequest;
import org.tkit.rhpam.task.model.JBPMTaskDTO;
import org.tkit.rhpam.task.model.OrgaReferenceDTO;
import org.tkit.rhpam.task.model.Priority;
import org.tkit.rhpam.task.model.TaskCompleteRequest;
import org.tkit.rhpam.task.model.UserReferenceDTO;

public class UserTaskListener
implements TaskLifeCycleEventListener {
    private Logger log = LoggerFactory.getLogger(UserTaskListener.class);
    private String apiUrl;
    private String kieApiUrl;
    private String namespace;
    private String serverId;

    public UserTaskListener(String url, String namespace, String kieApiUrl) {
        this(url, namespace);
        this.kieApiUrl = kieApiUrl;
    }

    public UserTaskListener(String url, String namespace) {
        this(url);
        this.namespace = namespace;
    }

    public UserTaskListener(String url) {
        this.apiUrl = url;
        this.serverId = KieServerEnvironment.getServerId();
        if (this.serverId == null) {
            this.serverId = KieServerEnvironment.getServerName();
        }
    }

    public void beforeTaskActivatedEvent(TaskEvent taskEvent) {
        this.log.info("beforeTaskActivatedEvent {}", (Object)taskEvent.getTask(), (Object)taskEvent.getTaskContext());
    }

    public void beforeTaskClaimedEvent(TaskEvent taskEvent) {
        this.log.info("beforeTaskClaimedEvent {}", (Object)taskEvent);
    }

    public void beforeTaskSkippedEvent(TaskEvent taskEvent) {
        this.log.info("beforeTaskSkippedEvent {}", (Object)taskEvent);
    }

    public void beforeTaskStartedEvent(TaskEvent taskEvent) {
        this.log.info("beforeTaskStartedEvent {}", (Object)taskEvent);
    }

    public void beforeTaskStoppedEvent(TaskEvent taskEvent) {
        this.log.info("beforeTaskStoppedEvent {}", (Object)taskEvent);
    }

    public void beforeTaskCompletedEvent(TaskEvent taskEvent) {
        this.log.info("beforeTaskCompletedEvent {}", (Object)taskEvent);
    }

    public void beforeTaskFailedEvent(TaskEvent taskEvent) {
        this.log.info("beforeTaskFailedEvent {}", (Object)taskEvent);
    }

    public void beforeTaskAddedEvent(TaskEvent taskEvent) {
        this.log.info("beforeTaskAddedEvent {}", (Object)taskEvent.getTask(), (Object)taskEvent.getTaskContext());
    }

    public void beforeTaskExitedEvent(TaskEvent taskEvent) {
        this.log.info("beforeTaskExitedEvent {}", (Object)taskEvent);
    }

    public void beforeTaskReleasedEvent(TaskEvent taskEvent) {
        this.log.info("beforeTaskReleasedEvent {}", (Object)taskEvent);
    }

    public void beforeTaskResumedEvent(TaskEvent taskEvent) {
        this.log.info("beforeTaskResumedEvent {}", (Object)taskEvent);
    }

    public void beforeTaskSuspendedEvent(TaskEvent taskEvent) {
        this.log.info("beforeTaskSuspendedEvent {}", (Object)taskEvent);
    }

    public void beforeTaskForwardedEvent(TaskEvent taskEvent) {
        this.log.info("beforeTaskForwardedEvent {}", (Object)taskEvent);
    }

    public void beforeTaskDelegatedEvent(TaskEvent taskEvent) {
        this.log.info("beforeTaskDelegatedEvent {}", (Object)taskEvent);
    }

    public void beforeTaskNominatedEvent(TaskEvent taskEvent) {
        this.log.info("beforeTaskNominatedEvent {}", (Object)taskEvent);
    }

    public void afterTaskActivatedEvent(TaskEvent taskEvent) {
        this.log.info("afterTaskActivatedEvent {}", (Object)taskEvent);
    }

    public void afterTaskClaimedEvent(TaskEvent taskEvent) {
        this.log.info("afterTaskClaimedEvent {}", (Object)taskEvent);
    }

    public void afterTaskSkippedEvent(TaskEvent taskEvent) {
        this.log.info("afterTaskSkippedEvent {}", (Object)taskEvent);
    }

    public void afterTaskStartedEvent(TaskEvent taskEvent) {
        this.log.info("afterTaskStartedEvent {}", (Object)taskEvent);
    }

    public void afterTaskStoppedEvent(TaskEvent taskEvent) {
        this.log.info("afterTaskStoppedEvent {}", (Object)taskEvent);
    }

    public void afterTaskCompletedEvent(TaskEvent taskEvent) {
        this.log.info("afterTaskCompletedEvent {}", (Object)taskEvent);
        Task task = taskEvent.getTask();
        if (task == null) {
            this.log.error("Task is empty");
            return;
        }
        if (task.getTaskData() == null) {
            this.log.warn("task data empty");
            return;
        }
        TaskData taskData = task.getTaskData();
        StringBuilder sb = new StringBuilder(this.apiUrl);
        sb.append("/").append(taskData.getDeploymentId());
        sb.append("/").append(taskData.getProcessInstanceId());
        sb.append("/").append(task.getId());
        sb.append("/complete");
        HttpPost request = new HttpPost(sb.toString());
        request.addHeader("Accept", "application/json");
        request.addHeader("Content-Type", "application/json");
        TaskCompleteRequest completeRequest = new TaskCompleteRequest();
        completeRequest.setAuthor(taskEvent.getTaskContext().getUserId());
        completeRequest.setResolutionComment("Complete from jbpm server");
        completeRequest.setResolutionDate(new Date());
        Map<String, String> outputParams = taskData.getTaskOutputVariables().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue())));
        completeRequest.setResolutionParameters(outputParams);
        ObjectMapper mapper = new ObjectMapper();
        try {
            request.setEntity((HttpEntity)new StringEntity(mapper.writeValueAsString((Object)completeRequest)));
        }
        catch (UnsupportedEncodingException e2) {
            this.log.error("Error creating json request", (Throwable)e2);
            return;
        }
        catch (JsonProcessingException e3) {
            this.log.error("Error creating json request", (Throwable)e3);
            return;
        }
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            this.log.info(response.getStatusLine().toString());
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                String result = EntityUtils.toString((HttpEntity)entity);
                this.log.info(result);
            }
        }
        catch (ClientProtocolException e4) {
            this.log.error("Clientprotocol exception: ", (Throwable)e4);
        }
        catch (IOException e5) {
            this.log.error("IOException: ", (Throwable)e5);
        }
    }

    public void afterTaskFailedEvent(TaskEvent taskEvent) {
        this.log.info("afterTaskFailedEvent {}", (Object)taskEvent);
    }

    public void afterTaskAddedEvent(TaskEvent taskEvent) {
        this.log.info("afterTaskAddedEvent {}", (Object)taskEvent);
        HttpPost request = new HttpPost(this.apiUrl);
        request.addHeader("Accept", "application/json");
        request.addHeader("Content-Type", "application/json");
        CreateTaskRequest taskRequest = new CreateTaskRequest();
        taskRequest.setSource(this.serverId);
        taskRequest.setComment("auto generated task from user task listener");
        taskRequest.setDirectTask(Boolean.FALSE);
        taskRequest.setPriority(Priority.MINOR);
        taskRequest.setTaskName(taskEvent.getTask().getName());
        Task task = taskEvent.getTask();
        if (task == null) {
            this.log.error("Task is empty");
            return;
        }
        InternalPeopleAssignments ipa = null;
        if (task.getPeopleAssignments() != null) {
            ipa = (InternalPeopleAssignments)task.getPeopleAssignments();
        }
        if (ipa != null && ipa.getRecipients() != null && ipa.getRecipients().size() > 0) {
            UserReferenceDTO userReference = new UserReferenceDTO();
            userReference.setUserId(((InternalPeopleAssignments)taskEvent.getTask().getPeopleAssignments()).getRecipients().stream().map(OrganizationalEntity::getId).collect(Collectors.joining(",")));
            taskRequest.setUserReference(userReference);
        }
        if (ipa != null && ipa.getPotentialOwners() != null && ipa.getRecipients().size() > 0) {
            OrgaReferenceDTO orgaReference = new OrgaReferenceDTO();
            orgaReference.setOrgaId(taskEvent.getTask().getPeopleAssignments().getPotentialOwners().stream().map(OrganizationalEntity::getId).collect(Collectors.joining(",")));
            taskRequest.setOrgaReference(orgaReference);
        }
        if (task.getTaskData() == null) {
            this.log.warn("task data empty");
            return;
        }
        TaskData taskData = task.getTaskData();
        String callbackUrl = this.getCallbackUrl(taskData.getDeploymentId(), task.getId());
        taskRequest.setCallbackURL(callbackUrl);
        JBPMTaskDTO jbpmTask = new JBPMTaskDTO();
        jbpmTask.setDeploymentId(taskData.getDeploymentId());
        jbpmTask.setProcessId(taskData.getProcessId());
        jbpmTask.setProcessInstanceId(taskData.getProcessInstanceId());
        jbpmTask.setTaskInstanceId(task.getId());
        taskRequest.setJbpmTask(jbpmTask);
        List<AdditionContentDTO> contentList = taskData.getTaskInputVariables().entrySet().stream().map(e -> new AdditionContentDTO((String)e.getKey(), e.getValue() + "")).collect(Collectors.toList());
        taskRequest.setAdditionalContentList(contentList);
        ObjectMapper mapper = new ObjectMapper();
        try {
            request.setEntity((HttpEntity)new StringEntity(mapper.writeValueAsString((Object)taskRequest)));
        }
        catch (UnsupportedEncodingException e2) {
            this.log.error("Error creating json request", (Throwable)e2);
            return;
        }
        catch (JsonProcessingException e3) {
            this.log.error("Error creating json request", (Throwable)e3);
            return;
        }
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            this.log.info(response.getStatusLine().toString());
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                String result = EntityUtils.toString((HttpEntity)entity);
                this.log.info(result);
            }
        }
        catch (ClientProtocolException e4) {
            this.log.error("Clientprotocol exception: ", (Throwable)e4);
        }
        catch (IOException e5) {
            this.log.error("IOException: ", (Throwable)e5);
        }
    }

    public void afterTaskExitedEvent(TaskEvent taskEvent) {
        this.log.info("afterTaskExitedEvent {}", (Object)taskEvent);
    }

    public void afterTaskReleasedEvent(TaskEvent taskEvent) {
        this.log.info("afterTaskReleasedEvent {}", (Object)taskEvent);
    }

    public void afterTaskResumedEvent(TaskEvent taskEvent) {
        this.log.info("afterTaskResumedEvent {}", (Object)taskEvent);
    }

    public void afterTaskSuspendedEvent(TaskEvent taskEvent) {
        this.log.info("afterTaskSuspendedEvent {}", (Object)taskEvent);
    }

    public void afterTaskForwardedEvent(TaskEvent taskEvent) {
        this.log.info("afterTaskForwardedEvent {}", (Object)taskEvent);
    }

    public void afterTaskDelegatedEvent(TaskEvent taskEvent) {
        this.log.info("afterTaskDelegatedEvent {}", (Object)taskEvent);
    }

    public void afterTaskNominatedEvent(TaskEvent taskEvent) {
        this.log.info("afterTaskNominatedEvent {}", (Object)taskEvent);
    }

    private String getCallbackUrl(String deploymentId, Long taskId) {
        StringBuilder sb;
        if (this.kieApiUrl == null) {
            sb = new StringBuilder();
            this.log.info("Callback kie server url null. Creation of callback url is dynamic.");
            if (this.namespace != null) {
                sb.append("http://");
                sb.append(this.serverId).append(".");
                sb.append(this.namespace).append(".svc.cluster.local:8080");
                this.log.info("Namespace was defined using local openshift url for callback.");
            } else {
                String url = System.getenv("KIE_SERVER_LOCATION");
                if (url != null) {
                    this.log.info("Kie server location found {}. Set as callback url", (Object)url);
                    sb.append(url);
                } else {
                    sb.append("http://");
                    sb.append(this.serverId).append(":8080/");
                    this.log.info("Kie server location not defined using local url");
                }
            }
            this.kieApiUrl = sb.toString();
            this.log.info("Callback url set to {}", (Object)this.kieApiUrl);
        }
        sb = new StringBuilder(this.kieApiUrl);
        sb.append("/services/rest/server/containers/").append(deploymentId);
        sb.append("/tasks/").append(taskId).append("/states");
        return sb.toString();
    }
}

