/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.webapp.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extension {
    private static final long serialVersionUID = 1L;
    private final String point;
    private final Map<String, String> files;

    public Extension(String point, Map<String, String> files) {
        this.point = point;
        this.files = files;
    }

    public static Extension read(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() != 1) {
            throw new IllegalStateException("Expecting a start element");
        }
        if (!"extension".equals(reader.getLocalName())) {
            throw new IllegalStateException("Expecting a <extension> element");
        }
        String point = reader.getAttributeValue(null, "point");
        HashMap<String, String> files = new HashMap<String, String>();
        int depth = 0;
        while (reader.hasNext() && depth >= 0) {
            switch (reader.next()) {
                case 1: {
                    String file;
                    if (depth == 0 && (file = reader.getAttributeValue(null, "file")) != null) {
                        files.put(reader.getLocalName(), file);
                    }
                    ++depth;
                    break;
                }
                case 2: {
                    --depth;
                }
            }
        }
        return new Extension(point, files);
    }

    public String getPoint() {
        return this.point;
    }

    public Map<String, String> getFiles() {
        return this.files;
    }

    public String getFile(String key) {
        return (String)this.files.get(key);
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("extension");
        writer.writeAttribute("point", this.getPoint());
        for (Map.Entry file : this.getFiles().entrySet()) {
            writer.writeStartElement((String)file.getKey());
            writer.writeAttribute("file", (String)file.getValue());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Extension");
        sb.append("{point='").append(this.point).append('\'');
        sb.append(", files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }

    public static Map<String, Extension> toMap(Collection<Extension> extensions) {
        HashMap<String, Extension> result = new HashMap<String, Extension>(extensions.size());
        for (Extension e : extensions) {
            result.put(e.getPoint(), e);
        }
        return result;
    }
}

