/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.webapp.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.tobarsegais.webapp.data.IndexChild;
import org.tobarsegais.webapp.data.IndexSee;
import org.tobarsegais.webapp.data.IndexTopic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class IndexEntry
implements IndexChild {
    private static final long serialVersionUID = 1L;
    private final List<String> path;
    private final String keyword;
    private final List<IndexTopic> topics;
    private final List<IndexSee> sees;
    private final SortedMap<String, IndexEntry> subEntries;

    public IndexEntry(List<String> path, String keyword, Collection<IndexTopic> topics, Collection<IndexSee> sees, Collection<IndexEntry> subEntries) {
        this.path = path == null ? Collections.emptyList() : path;
        this.keyword = keyword;
        this.topics = topics == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<IndexTopic>(topics));
        this.sees = sees == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<IndexSee>(sees));
        TreeMap<String, IndexEntry> entryTreeMap = new TreeMap<String, IndexEntry>();
        for (IndexEntry entry : subEntries) {
            IndexEntry existing = (IndexEntry)entryTreeMap.get(entry.getKeyword());
            if (existing != null) {
                entryTreeMap.put(entry.getKeyword(), IndexEntry.merge((IndexEntry)existing, (IndexEntry[])new IndexEntry[]{entry}));
                continue;
            }
            entryTreeMap.put(entry.getKeyword(), entry);
        }
        this.subEntries = Collections.unmodifiableSortedMap(entryTreeMap);
    }

    public static IndexEntry merge(IndexEntry entry, IndexEntry ... entries) {
        ArrayList topics = new ArrayList(entry.getTopics());
        ArrayList sees = new ArrayList(entry.getSees());
        ArrayList subEntries = new ArrayList(entry.getSubEntries().values());
        for (IndexEntry e : entries) {
            topics.addAll(e.getTopics());
            sees.addAll(e.getSees());
            subEntries.addAll(e.getSubEntries().values());
        }
        return new IndexEntry(entry.getPath(), entry.getKeyword(), topics, sees, subEntries);
    }

    public static IndexEntry read(String bundle, List<String> path, XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() != 1) {
            throw new IllegalStateException("Expecting a start element");
        }
        if (!"entry".equals(reader.getLocalName())) {
            throw new IllegalStateException("Expecting a <entry> element, got a <" + reader.getLocalName() + ">");
        }
        String keyword = reader.getAttributeValue(null, "keyword");
        ArrayList<IndexTopic> topics = new ArrayList<IndexTopic>();
        ArrayList<IndexSee> sees = new ArrayList<IndexSee>();
        ArrayList<IndexEntry> subEntries = new ArrayList<IndexEntry>();
        ArrayList<String> childPath = new ArrayList<String>(path);
        childPath.add(keyword);
        int depth = 0;
        while (reader.hasNext() && depth >= 0) {
            switch (reader.next()) {
                case 1: {
                    if (depth == 0 && "topic".equals(reader.getLocalName())) {
                        topics.add(IndexTopic.read((String)bundle, (XMLStreamReader)reader));
                        break;
                    }
                    if (depth == 0 && "entry".equals(reader.getLocalName())) {
                        subEntries.add(IndexEntry.read((String)bundle, childPath, (XMLStreamReader)reader));
                        break;
                    }
                    if (depth == 0 && "see".equals(reader.getLocalName())) {
                        sees.add(IndexSee.read((XMLStreamReader)reader));
                        break;
                    }
                    ++depth;
                    break;
                }
                case 2: {
                    --depth;
                }
            }
        }
        return new IndexEntry(path, keyword, topics, sees, subEntries);
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("entry");
        writer.writeAttribute("keyword", this.getKeyword());
        for (IndexTopic topic : this.getTopics()) {
            topic.write(writer);
        }
        for (IndexSee see : this.getSees()) {
            see.write(writer);
        }
        for (IndexEntry entry : this.getSubEntries().values()) {
            entry.write(writer);
        }
        writer.writeEndElement();
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IndexEntry");
        sb.append("{keyword='").append(this.getKeyword()).append('\'');
        sb.append(", topics=").append(this.getTopics());
        sb.append(", sees=").append(this.getSees());
        sb.append(", subEntries=").append(this.getSubEntries());
        sb.append('}');
        return sb.toString();
    }

    public List<String> getPath() {
        return this.path;
    }

    public List<IndexTopic> getTopics() {
        return this.topics;
    }

    public List<IndexSee> getSees() {
        return this.sees;
    }

    public SortedMap<String, IndexEntry> getSubEntries() {
        return this.subEntries;
    }

    public boolean hasChildren() {
        return !this.getTopics().isEmpty() || !this.getSees().isEmpty() || !this.getSubEntries().isEmpty();
    }
}

