/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.webapp;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class RedirectFilter
implements Filter {
    private String domain = null;
    private int status = 302;

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext ctx = filterConfig.getServletContext();
        this.domain = ctx.getInitParameter(RedirectFilter.class.getName() + ".domain");
        String statusStr = ctx.getInitParameter(RedirectFilter.class.getName() + ".status");
        if (StringUtils.isNotBlank((CharSequence)statusStr)) {
            try {
                switch (Integer.parseInt(statusStr)) {
                    case 301: {
                        this.status = 301;
                        break;
                    }
                    case 307: {
                        this.status = 307;
                        break;
                    }
                    case 308: {
                        this.status = 308;
                        break;
                    }
                    default: {
                        this.status = 302;
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (StringUtils.isEmpty((CharSequence)this.domain) || !(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
        } else {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            String serverName = req.getServerName();
            if (this.domain.equalsIgnoreCase(serverName)) {
                chain.doFilter(request, response);
            } else {
                StringBuffer requestURL = req.getRequestURL();
                int index = requestURL.indexOf(serverName);
                requestURL.replace(index, index + serverName.length(), this.domain);
                String queryString = req.getQueryString();
                if (queryString != null) {
                    requestURL.append('?').append(queryString);
                }
                resp.setStatus(this.status);
                resp.setHeader("Location", requestURL.toString());
            }
        }
    }

    public void destroy() {
    }
}

