/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.webapp.data;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.IOUtils;
import org.tobarsegais.webapp.data.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Plugin {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String id;
    private final String version;
    private final String providerName;
    private final Map<String, Extension> extensions;

    public Plugin(String name, String id, String version, String providerName, Extension ... extensions) {
        this(name, id, version, providerName, Extension.toMap(Arrays.asList(extensions)));
    }

    public Plugin(String name, String id, String version, String providerName, Map<String, Extension> extensions) {
        this.name = name;
        this.id = id;
        this.version = version;
        this.providerName = providerName;
        this.extensions = extensions;
    }

    public Plugin(String name, String id, String version, String providerName, Collection<Extension> extensions) {
        this(name, id, version, providerName, Extension.toMap(extensions));
    }

    public static Plugin read(InputStream inputStream) throws XMLStreamException {
        try {
            Plugin plugin = Plugin.read((XMLStreamReader)XMLInputFactory.newInstance().createXMLStreamReader(inputStream));
            return plugin;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static Plugin read(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext() && !reader.isStartElement()) {
            reader.next();
        }
        if (reader.getEventType() != 1) {
            throw new IllegalStateException("Expecting a start element");
        }
        if (!"plugin".equals(reader.getLocalName())) {
            throw new IllegalStateException("Expecting a <plugin> element");
        }
        String name = reader.getAttributeValue(null, "name");
        String id = reader.getAttributeValue(null, "id");
        String version = reader.getAttributeValue(null, "version");
        String providerName = reader.getAttributeValue(null, "provider-name");
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        int depth = 0;
        while (reader.hasNext() && depth >= 0) {
            switch (reader.next()) {
                case 1: {
                    if (depth == 0 && "extension".equals(reader.getLocalName())) {
                        extensions.add(Extension.read((XMLStreamReader)reader));
                        break;
                    }
                    ++depth;
                    break;
                }
                case 2: {
                    --depth;
                }
            }
        }
        return new Plugin(name, id, version, providerName, extensions);
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public Map<String, Extension> getExtensions() {
        return this.extensions;
    }

    public Extension getExtension(String point) {
        return (Extension)this.extensions.get(point);
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("plugin");
        writer.writeAttribute("name", this.getName());
        writer.writeAttribute("id", this.getId());
        writer.writeAttribute("version", this.getVersion());
        writer.writeAttribute("provider-name", this.getProviderName());
        for (Extension extension : this.getExtensions().values()) {
            extension.write(writer);
        }
        writer.writeEndElement();
    }
}

