/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.webapp.data;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.IOUtils;
import org.tobarsegais.webapp.data.TocEntry;
import org.tobarsegais.webapp.data.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Toc
extends TocEntry {
    private static final long serialVersionUID = 1L;

    public Toc(String label, String topic, Topic ... children) {
        this(label, topic, Arrays.asList(children));
    }

    public Toc(String label, String topic, Collection<Topic> children) {
        super(label, topic, children);
    }

    public static Toc read(InputStream inputStream) throws XMLStreamException {
        try {
            Toc toc = Toc.read((XMLStreamReader)XMLInputFactory.newInstance().createXMLStreamReader(inputStream));
            return toc;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static Toc read(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext() && !reader.isStartElement()) {
            reader.next();
        }
        if (reader.getEventType() != 1) {
            throw new IllegalStateException("Expecting a start element");
        }
        if (!"toc".equals(reader.getLocalName())) {
            throw new IllegalStateException("Expecting a <toc> element");
        }
        String label = reader.getAttributeValue(null, "label");
        String topic = reader.getAttributeValue(null, "topic");
        ArrayList<Topic> topics = new ArrayList<Topic>();
        int depth = 0;
        while (reader.hasNext() && depth >= 0) {
            switch (reader.next()) {
                case 1: {
                    if (depth == 0 && "topic".equals(reader.getLocalName())) {
                        topics.add(Topic.read((XMLStreamReader)reader));
                        break;
                    }
                    ++depth;
                    break;
                }
                case 2: {
                    --depth;
                }
            }
        }
        return new Toc(label, topic, topics);
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("toc");
        writer.writeAttribute("label", this.getLabel());
        writer.writeAttribute("topic", this.getHref());
        for (Topic topic : this.getChildren()) {
            topic.write(writer);
        }
        writer.writeEndElement();
    }
}

