/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.webapp.data;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.IOUtils;
import org.tobarsegais.webapp.data.IndexEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Index
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<IndexEntry> children;
    private final SortedMap<String, IndexEntry> entries;
    private final Map<IndexEntry, String> ids;

    public Index(IndexEntry ... children) {
        this(Arrays.asList(children));
    }

    public Index(Collection<IndexEntry> children) {
        this.children = children == null || children.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<IndexEntry>(children));
        TreeMap<String, IndexEntry> entryTreeMap = new TreeMap<String, IndexEntry>();
        for (IndexEntry entry : this.getChildren()) {
            IndexEntry existing = (IndexEntry)entryTreeMap.get(entry.getKeyword());
            if (existing != null) {
                entryTreeMap.put(entry.getKeyword(), IndexEntry.merge((IndexEntry)existing, (IndexEntry[])new IndexEntry[]{entry}));
                continue;
            }
            entryTreeMap.put(entry.getKeyword(), entry);
        }
        this.entries = Collections.unmodifiableSortedMap(entryTreeMap);
        HashMap<IndexEntry, String> ids = new HashMap<IndexEntry, String>();
        int id = 0;
        Stack stack = new Stack();
        stack.push(this.entries.values().iterator());
        while (!stack.isEmpty()) {
            Iterator iterator = (Iterator)stack.pop();
            while (iterator.hasNext()) {
                IndexEntry indexEntry = (IndexEntry)iterator.next();
                stack.push(iterator);
                ids.put(indexEntry, Integer.toHexString(id++));
                if (indexEntry.getSubEntries().isEmpty()) continue;
                stack.push(indexEntry.getSubEntries().values().iterator());
            }
        }
        this.ids = Collections.unmodifiableMap(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Index read(String bundle, InputStream inputStream) throws XMLStreamException {
        try {
            Index index = Index.read((String)bundle, (XMLStreamReader)XMLInputFactory.newInstance().createXMLStreamReader(inputStream));
            return index;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static Index read(String bundle, XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext() && !reader.isStartElement()) {
            reader.next();
        }
        if (reader.getEventType() != 1) {
            throw new IllegalStateException("Expecting a start element");
        }
        if (!"index".equals(reader.getLocalName())) {
            throw new IllegalStateException("Expecting a <index> element, found a <" + reader.getLocalName() + ">");
        }
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
        int depth = 0;
        while (reader.hasNext() && depth >= 0) {
            switch (reader.next()) {
                case 1: {
                    if (depth == 0 && "entry".equals(reader.getLocalName())) {
                        entries.add(IndexEntry.read((String)bundle, Collections.emptyList(), (XMLStreamReader)reader));
                        break;
                    }
                    ++depth;
                    break;
                }
                case 2: {
                    --depth;
                }
            }
        }
        return new Index(entries);
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("index");
        for (IndexEntry topic : this.getChildren()) {
            topic.write(writer);
        }
        writer.writeEndElement();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Index");
        sb.append("{children=").append(this.getChildren());
        sb.append('}');
        return sb.toString();
    }

    public List<IndexEntry> getChildren() {
        return this.children == null ? Collections.emptyList() : this.children;
    }

    public SortedMap<String, IndexEntry> getEntries() {
        return this.entries;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public IndexEntry findEntry(List<String> keywordPath) {
        return this.findEntry(keywordPath.iterator());
    }

    private IndexEntry findEntry(Iterator<String> iterator) {
        if (iterator.hasNext()) {
            String keyword = iterator.next();
            IndexEntry indexEntry = (IndexEntry)this.getEntries().get(keyword);
            while (indexEntry != null && iterator.hasNext()) {
                keyword = iterator.next();
                indexEntry = (IndexEntry)indexEntry.getSubEntries().get(keyword);
            }
            return indexEntry;
        }
        return null;
    }

    public String getId(IndexEntry indexEntry) {
        return (String)this.ids.get(indexEntry);
    }
}

