/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.webapp;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tobarsegais.webapp.ServletContextListenerImpl;
import org.tobarsegais.webapp.data.Toc;
import org.tobarsegais.webapp.data.TocEntry;

public class DocsServlet
extends HttpServlet {
    public static final String PLUGINS_ROOT = "/PLUGINS_ROOT/";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int index;
        boolean raw = req.getParameter("raw") != null;
        String topicKey = req.getParameter("topic");
        boolean isTopic = topicKey != null && topicKey.length() > 0;
        String path = req.getPathInfo();
        if (path == null) {
            path = req.getServletPath();
        }
        if ((index = path.indexOf(PLUGINS_ROOT)) != -1) {
            path = path.substring(index + PLUGINS_ROOT.length() - 1);
        }
        if (isTopic) {
            path = this.findTopicPath(topicKey);
        }
        if (path.equals("/docs")) {
            resp.sendRedirect("/docs/");
            return;
        }
        int endOfFileName = path.indexOf(35);
        endOfFileName = endOfFileName == -1 ? path.length() : endOfFileName;
        int startOfFileName = path.lastIndexOf(47, endOfFileName);
        startOfFileName = startOfFileName == -1 ? 0 : startOfFileName + 1;
        String fileName = path.substring(startOfFileName, endOfFileName);
        if (raw || !fileName.toLowerCase().endsWith(".htm") && !fileName.toLowerCase().endsWith(".html") && !fileName.isEmpty()) {
            req.getRequestDispatcher("/content" + path).forward((ServletRequest)req, (ServletResponse)resp);
        } else {
            if (isTopic) {
                req.setAttribute("content", (Object)path);
            } else {
                req.setAttribute("content", (Object)req.getPathInfo());
            }
            req.getRequestDispatcher("/WEB-INF/docs-template.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    protected String findTopicPath(String topicKey) {
        ServletContext application = this.getServletContext();
        Map contents = ServletContextListenerImpl.getTablesOfContents((ServletContext)application);
        for (Map.Entry entry : contents.entrySet()) {
            TocEntry tocEntry = ((Toc)entry.getValue()).lookupTopic(topicKey);
            if (tocEntry == null) continue;
            return "/" + (String)entry.getKey() + "/" + tocEntry.getHref();
        }
        return "/docs";
    }
}

