/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.webapp;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.tobarsegais.webapp.data.Extension;
import org.tobarsegais.webapp.data.Index;
import org.tobarsegais.webapp.data.Plugin;
import org.tobarsegais.webapp.data.Toc;
import org.tobarsegais.webapp.data.TocEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContextListenerImpl
implements ServletContextListener {
    public static final String BUNDLE_PATH = "/WEB-INF/bundles";
    public static final Version LUCENE_VERSON = Version.LUCENE_36;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        IndexWriter indexWriter;
        ServletContext application = sce.getServletContext();
        HashMap<String, String> bundles = new HashMap<String, String>();
        LinkedHashMap<String, Toc> contents = new LinkedHashMap<String, Toc>();
        ArrayList keywords = new ArrayList();
        RAMDirectory index = new RAMDirectory();
        StandardAnalyzer analyzer = new StandardAnalyzer(LUCENE_VERSON);
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(LUCENE_VERSON, (Analyzer)analyzer);
        try {
            indexWriter = new IndexWriter((Directory)index, indexWriterConfig);
        }
        catch (IOException e) {
            application.log("Cannot create search index. Search will be unavailable.", (Throwable)e);
            indexWriter = null;
        }
        for (String path : application.getResourcePaths(BUNDLE_PATH)) {
            if (!path.endsWith(".jar")) continue;
            String key = path.substring("/WEB-INF/bundles/".length(), path.lastIndexOf(".jar"));
            application.log("Parsing " + path);
            URLConnection connection = null;
            try {
                Toc toc;
                JarEntry pluginEntry;
                String symbolicName;
                URL url = new URL("jar:" + application.getResource(path) + "!/");
                connection = url.openConnection();
                if (!(connection instanceof JarURLConnection)) {
                    application.log(path + " is not a jar file, ignoring");
                    continue;
                }
                JarURLConnection jarConnection = (JarURLConnection)connection;
                JarFile jarFile = jarConnection.getJarFile();
                Manifest manifest = jarFile.getManifest();
                if (manifest != null && (symbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName")) != null) {
                    int i = symbolicName.indexOf(59);
                    if (i != -1) {
                        symbolicName = symbolicName.substring(0, i);
                    }
                    bundles.put(symbolicName, key);
                    key = symbolicName;
                }
                if ((pluginEntry = jarFile.getJarEntry("plugin.xml")) == null) {
                    application.log(path + " does not contain a plugin.xml file, ignoring");
                    continue;
                }
                Plugin plugin = Plugin.read((InputStream)jarFile.getInputStream(pluginEntry));
                Extension tocExtension = plugin.getExtension("org.eclipse.help.toc");
                if (tocExtension == null || tocExtension.getFile("toc") == null) {
                    application.log(path + " does not contain a 'org.eclipse.help.toc' extension, ignoring");
                    continue;
                }
                JarEntry tocEntry = jarFile.getJarEntry(tocExtension.getFile("toc"));
                if (tocEntry == null) {
                    application.log(path + " is missing the referenced toc: " + tocExtension.getFile("toc") + ", ignoring");
                    continue;
                }
                try {
                    toc = Toc.read((InputStream)jarFile.getInputStream(tocEntry));
                }
                catch (IllegalStateException e) {
                    application.log("Could not parse " + path + " due to " + e.getMessage(), (Throwable)e);
                    if (!(connection instanceof HttpURLConnection)) continue;
                    ((HttpURLConnection)connection).disconnect();
                    continue;
                }
                contents.put(key, toc);
                Extension indexExtension = plugin.getExtension("org.eclipse.help.index");
                if (indexExtension != null && indexExtension.getFile("index") != null) {
                    JarEntry indexEntry = jarFile.getJarEntry(indexExtension.getFile("index"));
                    if (indexEntry != null) {
                        try {
                            keywords.addAll(Index.read((String)key, (InputStream)jarFile.getInputStream(indexEntry)).getChildren());
                        }
                        catch (IllegalStateException e) {
                            application.log("Could not parse " + path + " due to " + e.getMessage(), (Throwable)e);
                        }
                    } else {
                        application.log(path + " is missing the referenced index: " + indexExtension.getFile("index"));
                    }
                }
                application.log(path + " successfully parsed and added as " + key);
                if (indexWriter == null) continue;
                application.log("Indexing content of " + path);
                HashSet files = new HashSet();
                Stack stack = new Stack();
                stack.push(Collections.singleton(toc).iterator());
                while (!stack.empty()) {
                    String file;
                    Iterator cur = (Iterator)stack.pop();
                    if (!cur.hasNext()) continue;
                    TocEntry entry = (TocEntry)cur.next();
                    stack.push(cur);
                    if (!entry.getChildren().isEmpty()) {
                        stack.push(entry.getChildren().iterator());
                    }
                    if ((file = entry.getHref()) == null) continue;
                    int hashIndex = file.indexOf(35);
                    if (hashIndex != -1) {
                        file = file.substring(0, hashIndex);
                    }
                    if (files.contains(file)) continue;
                    org.apache.lucene.document.Document document = new org.apache.lucene.document.Document();
                    document.add((Fieldable)new Field("title", entry.getLabel(), Field.Store.YES, Field.Index.ANALYZED));
                    document.add((Fieldable)new Field("href", key + "/" + entry.getHref(), Field.Store.YES, Field.Index.NO));
                    JarEntry docEntry = jarFile.getJarEntry(file);
                    if (docEntry == null) continue;
                    InputStream inputStream = null;
                    try {
                        inputStream = jarFile.getInputStream(docEntry);
                        Document docDoc = Jsoup.parse((String)IOUtils.toString((InputStream)inputStream));
                        document.add((Fieldable)new Field("contents", docDoc.body().text(), Field.Store.NO, Field.Index.ANALYZED));
                        indexWriter.addDocument(document);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)inputStream);
                    }
                }
            }
            catch (XMLStreamException e) {
                application.log("Could not parse " + path + " due to " + e.getMessage(), (Throwable)e);
            }
            catch (MalformedURLException e) {
                application.log("Could not parse " + path + " due to " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                application.log("Could not parse " + path + " due to " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (!(connection instanceof HttpURLConnection)) continue;
                ((HttpURLConnection)connection).disconnect();
            }
        }
        if (indexWriter != null) {
            try {
                indexWriter.close();
            }
            catch (IOException e) {
                application.log("Cannot create search index. Search will be unavailable.", (Throwable)e);
            }
            application.setAttribute("index", (Object)index);
        }
        application.setAttribute("toc", Collections.unmodifiableMap(contents));
        application.setAttribute("keywords", (Object)new Index(keywords));
        application.setAttribute("bundles", Collections.unmodifiableMap(bundles));
        application.setAttribute("analyzer", (Object)analyzer);
        application.setAttribute("contentsQueryParser", (Object)new QueryParser(LUCENE_VERSON, "contents", (Analyzer)analyzer));
    }

    public static Map<String, Toc> getTablesOfContents(ServletContext application) {
        return (Map)application.getAttribute("toc");
    }

    public static Map<String, String> getBundles(ServletContext application) {
        return (Map)application.getAttribute("bundles");
    }

    public static Index getKeywordsIndex(ServletContext application) {
        return (Index)application.getAttribute("keywords");
    }

    public static Directory getDirectory(ServletContext application) {
        return (Directory)application.getAttribute("index");
    }

    public static Analyzer getAnalyzer(ServletContext application) {
        return (Analyzer)application.getAttribute("analyzer");
    }

    public static QueryParser getContentsQueryParser(ServletContext application) {
        return (QueryParser)application.getAttribute("contentsQueryParser");
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

