/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.webapp.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.tobarsegais.webapp.data.IndexChild;
import org.tobarsegais.webapp.data.IndexSubpath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexSee
implements IndexChild {
    private static final long serialVersionUID = 1L;
    private final List<String> keywordPath;

    public IndexSee(String ... keywordPath) {
        this(Arrays.asList(keywordPath));
    }

    public IndexSee(List<String> keywordPath) {
        this.keywordPath = Collections.unmodifiableList(keywordPath == null ? Collections.emptyList() : keywordPath);
    }

    public static IndexSee read(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() != 1) {
            throw new IllegalStateException("Expecting a start element");
        }
        if (!"see".equals(reader.getLocalName())) {
            throw new IllegalStateException("Expecting a <see> element, got a <" + reader.getLocalName() + ">");
        }
        ArrayList<String> keywordPath = new ArrayList<String>();
        keywordPath.add(reader.getAttributeValue(null, "keyword"));
        int depth = 0;
        while (reader.hasNext() && depth >= 0) {
            switch (reader.next()) {
                case 1: {
                    if (depth == 0 && "subpath".equals(reader.getLocalName())) {
                        keywordPath.add(IndexSubpath.read((XMLStreamReader)reader).getKeyword());
                        break;
                    }
                    ++depth;
                    break;
                }
                case 2: {
                    --depth;
                }
            }
        }
        return new IndexSee(keywordPath);
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("see");
        Iterator keywordIterator = this.keywordPath.iterator();
        if (keywordIterator.hasNext()) {
            writer.writeAttribute("keyword", (String)keywordIterator.next());
        }
        while (keywordIterator.hasNext()) {
            new IndexSubpath((String)keywordIterator.next()).write(writer);
        }
        writer.writeEndElement();
    }

    public List<String> getKeywordPath() {
        return this.keywordPath;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IndexSee");
        sb.append("{keywordPath='").append(this.getKeywordPath()).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

