/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.webapp.data;

import java.io.Serializable;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class IndexSubpath
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String keyword;

    public IndexSubpath(String keyword) {
        this.keyword = keyword;
    }

    public static IndexSubpath read(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() != 1) {
            throw new IllegalStateException("Expecting a start element");
        }
        if (!"subpath".equals(reader.getLocalName())) {
            throw new IllegalStateException("Expecting a <subpath> element, got a <" + reader.getLocalName() + ">");
        }
        String keyword = reader.getAttributeValue(null, "keyword");
        int depth = 0;
        while (reader.hasNext() && depth >= 0) {
            switch (reader.next()) {
                case 1: {
                    ++depth;
                    break;
                }
                case 2: {
                    --depth;
                }
            }
        }
        return new IndexSubpath(keyword);
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("subpath");
        writer.writeAttribute("keyword", this.getKeyword());
        writer.writeEndElement();
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Subpath");
        sb.append("{keyword='").append(this.keyword).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

