/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.webapp.data;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.tobarsegais.webapp.data.IndexChild;

public class IndexTopic
implements IndexChild {
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String href;
    private final String bundle;

    public IndexTopic(String bundle, String href, String title) {
        this.title = title;
        this.href = href;
        this.bundle = bundle;
    }

    public static IndexTopic read(String bundle, XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() != 1) {
            throw new IllegalStateException("Expecting a start element");
        }
        if (!"topic".equals(reader.getLocalName())) {
            throw new IllegalStateException("Expecting a <topic> element, got a <" + reader.getLocalName() + ">");
        }
        String title = reader.getAttributeValue(null, "title");
        if (title == null) {
            title = reader.getAttributeValue(null, "label");
        }
        String href = reader.getAttributeValue(null, "href");
        int depth = 0;
        while (reader.hasNext() && depth >= 0) {
            switch (reader.next()) {
                case 1: {
                    ++depth;
                    break;
                }
                case 2: {
                    --depth;
                }
            }
        }
        return new IndexTopic(bundle, href, title);
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("topic");
        writer.writeAttribute("title", this.getTitle());
        writer.writeAttribute("href", this.getHref());
        writer.writeEndElement();
    }

    public String getHref() {
        return this.href;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBundle() {
        return this.bundle;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IndexTopic");
        sb.append("{bundle='").append(this.bundle).append('\'');
        sb.append(", href='").append(this.href).append('\'');
        sb.append(", title='").append(this.title).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

