/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.webapp.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.tobarsegais.webapp.data.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TocEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String label;
    private final List<Topic> children;
    private final String href;

    public TocEntry(String label, String href, Collection<Topic> children) {
        this.label = label;
        this.children = children == null || children.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Topic>(children));
        this.href = href;
    }

    public String getLabel() {
        return this.label;
    }

    public List<Topic> getChildren() {
        return this.children == null ? Collections.emptyList() : this.children;
    }

    public String getHref() {
        return this.href;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TocEntry");
        sb.append("{label='").append(this.getLabel()).append('\'');
        sb.append(", href='").append(this.getHref()).append('\'');
        sb.append(", children=").append(this.getChildren());
        sb.append('}');
        return sb.toString();
    }

    public TocEntry lookupTopic(String href) {
        if (href.equals(this.getHref())) {
            return this;
        }
        for (Topic topic : this.getChildren()) {
            if (href.equals(topic.getHref())) {
                return topic;
            }
            TocEntry r = topic.lookupTopic(href);
            if (r == null) continue;
            return r;
        }
        return null;
    }
}

